/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import javax.inject.Singleton;
import javax.ws.rs.core.NewCookie;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.HttpDateFormat;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.StringBuilderUtils;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public class NewCookieProvider
implements HeaderDelegateProvider<NewCookie> {
    @Override
    public boolean supports(Class<?> type) {
        return type == NewCookie.class;
    }

    @Override
    public String toString(NewCookie cookie) {
        Utils.throwIllegalArgumentExceptionIfNull(cookie, LocalizationMessages.NEW_COOKIE_IS_NULL());
        StringBuilder b2 = new StringBuilder();
        b2.append(cookie.getName()).append('=');
        StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getValue());
        b2.append(";").append("Version=").append(cookie.getVersion());
        if (cookie.getComment() != null) {
            b2.append(";Comment=");
            StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            b2.append(";Domain=");
            StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            b2.append(";Path=");
            StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getPath());
        }
        if (cookie.getMaxAge() != -1) {
            b2.append(";Max-Age=");
            b2.append(cookie.getMaxAge());
        }
        if (cookie.isSecure()) {
            b2.append(";Secure");
        }
        if (cookie.isHttpOnly()) {
            b2.append(";HttpOnly");
        }
        if (cookie.getExpiry() != null) {
            b2.append(";Expires=");
            b2.append(HttpDateFormat.getPreferredDateFormat().format(cookie.getExpiry()));
        }
        return b2.toString();
    }

    @Override
    public NewCookie fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.NEW_COOKIE_IS_NULL());
        return HttpHeaderReader.readNewCookie(header);
    }
}

