/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import javax.inject.Singleton;
import javax.ws.rs.core.Cookie;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.StringBuilderUtils;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public class CookieProvider
implements HeaderDelegateProvider<Cookie> {
    @Override
    public boolean supports(Class<?> type) {
        return type == Cookie.class;
    }

    @Override
    public String toString(Cookie cookie) {
        Utils.throwIllegalArgumentExceptionIfNull(cookie, LocalizationMessages.COOKIE_IS_NULL());
        StringBuilder b2 = new StringBuilder();
        b2.append("$Version=").append(cookie.getVersion()).append(';');
        b2.append(cookie.getName()).append('=');
        StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getValue());
        if (cookie.getDomain() != null) {
            b2.append(";$Domain=");
            StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            b2.append(";$Path=");
            StringBuilderUtils.appendQuotedIfWhitespace(b2, cookie.getPath());
        }
        return b2.toString();
    }

    @Override
    public Cookie fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.COOKIE_IS_NULL());
        return HttpHeaderReader.readCookie(header);
    }
}

