/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import javax.ws.rs.core.CacheControl;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public final class CacheControlProvider
implements HeaderDelegateProvider<CacheControl> {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern COMMA_SEPARATED_LIST = Pattern.compile("[\\s]*,[\\s]*");

    @Override
    public boolean supports(Class<?> type) {
        return type == CacheControl.class;
    }

    @Override
    public String toString(CacheControl header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.CACHE_CONTROL_IS_NULL());
        StringBuilder b2 = new StringBuilder();
        if (header.isPrivate()) {
            this.appendQuotedWithSeparator(b2, "private", this.buildListValue(header.getPrivateFields()));
        }
        if (header.isNoCache()) {
            this.appendQuotedWithSeparator(b2, "no-cache", this.buildListValue(header.getNoCacheFields()));
        }
        if (header.isNoStore()) {
            this.appendWithSeparator(b2, "no-store");
        }
        if (header.isNoTransform()) {
            this.appendWithSeparator(b2, "no-transform");
        }
        if (header.isMustRevalidate()) {
            this.appendWithSeparator(b2, "must-revalidate");
        }
        if (header.isProxyRevalidate()) {
            this.appendWithSeparator(b2, "proxy-revalidate");
        }
        if (header.getMaxAge() != -1) {
            this.appendWithSeparator(b2, "max-age", header.getMaxAge());
        }
        if (header.getSMaxAge() != -1) {
            this.appendWithSeparator(b2, "s-maxage", header.getSMaxAge());
        }
        for (Map.Entry<String, String> e2 : header.getCacheExtension().entrySet()) {
            this.appendWithSeparator(b2, e2.getKey(), this.quoteIfWhitespace(e2.getValue()));
        }
        return b2.toString();
    }

    private void readFieldNames(List<String> fieldNames, HttpHeaderReader reader) throws ParseException {
        if (!reader.hasNextSeparator('=', false)) {
            return;
        }
        reader.nextSeparator('=');
        fieldNames.addAll(Arrays.asList(COMMA_SEPARATED_LIST.split(reader.nextQuotedString())));
    }

    private int readIntValue(HttpHeaderReader reader, String directiveName) throws ParseException {
        reader.nextSeparator('=');
        int index = reader.getIndex();
        try {
            return Integer.parseInt(reader.nextToken().toString());
        }
        catch (NumberFormatException nfe) {
            ParseException pe = new ParseException("Error parsing integer value for " + directiveName + " directive", index);
            pe.initCause(nfe);
            throw pe;
        }
    }

    private void readDirective(CacheControl cacheControl, HttpHeaderReader reader) throws ParseException {
        String directiveName = reader.nextToken().toString().toLowerCase(Locale.ROOT);
        if ("private".equals(directiveName)) {
            cacheControl.setPrivate(true);
            this.readFieldNames(cacheControl.getPrivateFields(), reader);
        } else if ("public".equals(directiveName)) {
            cacheControl.getCacheExtension().put(directiveName, null);
        } else if ("no-cache".equals(directiveName)) {
            cacheControl.setNoCache(true);
            this.readFieldNames(cacheControl.getNoCacheFields(), reader);
        } else if ("no-store".equals(directiveName)) {
            cacheControl.setNoStore(true);
        } else if ("no-transform".equals(directiveName)) {
            cacheControl.setNoTransform(true);
        } else if ("must-revalidate".equals(directiveName)) {
            cacheControl.setMustRevalidate(true);
        } else if ("proxy-revalidate".equals(directiveName)) {
            cacheControl.setProxyRevalidate(true);
        } else if ("max-age".equals(directiveName)) {
            cacheControl.setMaxAge(this.readIntValue(reader, directiveName));
        } else if ("s-maxage".equals(directiveName)) {
            cacheControl.setSMaxAge(this.readIntValue(reader, directiveName));
        } else {
            String value = null;
            if (reader.hasNextSeparator('=', false)) {
                reader.nextSeparator('=');
                value = reader.nextTokenOrQuotedString().toString();
            }
            cacheControl.getCacheExtension().put(directiveName, value);
        }
    }

    @Override
    public CacheControl fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.CACHE_CONTROL_IS_NULL());
        try {
            HttpHeaderReader reader = HttpHeaderReader.newInstance(header);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            while (reader.hasNext()) {
                this.readDirective(cacheControl, reader);
                if (!reader.hasNextSeparator(',', true)) continue;
                reader.nextSeparator(',');
            }
            return cacheControl;
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Error parsing cache control '" + header + "'", pe);
        }
    }

    private void appendWithSeparator(StringBuilder b2, String field) {
        if (b2.length() > 0) {
            b2.append(", ");
        }
        b2.append(field);
    }

    private void appendQuotedWithSeparator(StringBuilder b2, String field, String value) {
        this.appendWithSeparator(b2, field);
        if (value != null && !value.isEmpty()) {
            b2.append("=\"");
            b2.append(value);
            b2.append("\"");
        }
    }

    private void appendWithSeparator(StringBuilder b2, String field, String value) {
        this.appendWithSeparator(b2, field);
        if (value != null && !value.isEmpty()) {
            b2.append("=");
            b2.append(value);
        }
    }

    private void appendWithSeparator(StringBuilder b2, String field, int value) {
        this.appendWithSeparator(b2, field);
        b2.append("=");
        b2.append(value);
    }

    private String buildListValue(List<String> values2) {
        StringBuilder b2 = new StringBuilder();
        for (String value : values2) {
            this.appendWithSeparator(b2, value);
        }
        return b2.toString();
    }

    private String quoteIfWhitespace(String value) {
        if (value == null) {
            return null;
        }
        Matcher m3 = WHITESPACE.matcher(value);
        if (m3.find()) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

