/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.KeyComparator;

public class KeyComparatorHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3000273665665137463L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    final KeyComparator<K> keyComparator;
    static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public KeyComparatorHashMap(int initialCapacity, float loadFactor, KeyComparator<K> keyComparator) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(LocalizationMessages.ILLEGAL_INITIAL_CAPACITY(initialCapacity));
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException(LocalizationMessages.ILLEGAL_LOAD_FACTOR(Float.valueOf(loadFactor)));
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.keyComparator = keyComparator;
        this.init();
    }

    public KeyComparatorHashMap(int initialCapacity, KeyComparator<K> keyComparator) {
        this(initialCapacity, 0.75f, keyComparator);
    }

    public KeyComparatorHashMap(KeyComparator<K> keyComparator) {
        this(16, 0.75f, keyComparator);
    }

    public KeyComparatorHashMap(Map<? extends K, ? extends V> m3, KeyComparator<K> keyComparator) {
        this(Math.max((int)((float)m3.size() / 0.75f) + 1, 16), 0.75f, keyComparator);
        super.putAllForCreate(m3);
    }

    public int getModCount() {
        return this.modCount;
    }

    void init() {
    }

    static <T> T maskNull(T key) {
        return (T)(key == null ? NULL_KEY : key);
    }

    static <T> boolean isNull(T key) {
        return key == NULL_KEY;
    }

    static <T> T unmaskNull(T key) {
        return key == NULL_KEY ? null : (T)key;
    }

    static int hash(Object x2) {
        int h2 = x2.hashCode();
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    static boolean eq(Object x2, Object y2) {
        return x2 == y2 || x2.equals(y2);
    }

    static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    int keyComparatorHash(K k2) {
        return KeyComparatorHashMap.isNull(k2) ? this.hash(k2.hashCode()) : this.hash(this.keyComparator.hash(k2));
    }

    int hash(int h2) {
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    boolean keyComparatorEq(K x2, K y2) {
        if (KeyComparatorHashMap.isNull(x2)) {
            return x2 == y2;
        }
        if (KeyComparatorHashMap.isNull(y2)) {
            return x2 == y2;
        }
        return x2 == y2 || this.keyComparator.equals(x2, y2);
    }

    @Override
    public V get(Object key) {
        Object k2 = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && this.keyComparatorEq(k2, e2.key)) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        Object k2 = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && this.keyComparatorEq(k2, e2.key)) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    Entry<K, V> getEntry(K key) {
        K k2 = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (!(e2 == null || e2.hash == hash && this.keyComparatorEq(k2, e2.key))) {
            e2 = e2.next;
        }
        return e2;
    }

    @Override
    public V put(K key, V value) {
        K k2 = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && this.keyComparatorEq(k2, e2.key)) {
                Object oldValue = e2.value;
                e2.value = value;
                e2.recordAccess(this);
                return oldValue;
            }
            e2 = e2.next;
        }
        ++this.modCount;
        this.addEntry(hash, k2, value, i2);
        return null;
    }

    private void putForCreate(K key, V value) {
        K k2 = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && this.keyComparatorEq(k2, e2.key)) {
                e2.value = value;
                return;
            }
            e2 = e2.next;
        }
        this.createEntry(hash, k2, value, i2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> m3) {
        for (Map.Entry<K, V> e2 : m3.entrySet()) {
            this.putForCreate(e2.getKey(), e2.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<K, V>[] newTable) {
        Entry<K, V>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j2 = 0; j2 < src.length; ++j2) {
            Entry next;
            Entry<K, V> e2 = src[j2];
            if (e2 == null) continue;
            src[j2] = null;
            do {
                next = e2.next;
                int i2 = KeyComparatorHashMap.indexFor(e2.hash, newCapacity);
                e2.next = newTable[i2];
                newTable[i2] = e2;
            } while ((e2 = next) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        int numKeysToBeAdded = m3.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e2 : m3.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e2 = this.removeEntryForKey(key);
        return e2 == null ? null : (V)e2.value;
    }

    Entry<K, V> removeEntryForKey(Object key) {
        Entry<K, V> prev;
        Object k2 = KeyComparatorHashMap.maskNull(key);
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = prev = this.table[i2];
        while (e2 != null) {
            Entry next = e2.next;
            if (e2.hash == hash && this.keyComparatorEq(k2, e2.key)) {
                ++this.modCount;
                --this.size;
                if (prev == e2) {
                    this.table[i2] = next;
                } else {
                    prev.next = next;
                }
                e2.recordRemoval(this);
                return e2;
            }
            prev = e2;
            e2 = next;
        }
        return e2;
    }

    Entry<K, V> removeMapping(Object o2) {
        Entry<K, V> prev;
        if (!(o2 instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o2;
        Object k2 = KeyComparatorHashMap.maskNull(entry.getKey());
        int hash = this.keyComparatorHash(k2);
        int i2 = KeyComparatorHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e2 = prev = this.table[i2];
        while (e2 != null) {
            Entry next = e2.next;
            if (e2.hash == hash && e2.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e2) {
                    this.table[i2] = next;
                } else {
                    prev.next = next;
                }
                e2.recordRemoval(this);
                return e2;
            }
            prev = e2;
            e2 = next;
        }
        return e2;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K, V>[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            tab[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry<K, V> e2 = tab[i2];
            while (e2 != null) {
                if (value.equals(e2.value)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab;
        Entry<K, V>[] entryArray = tab = this.table;
        int n2 = entryArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Entry<K, V> aTab;
            Entry<K, V> e2 = aTab = entryArray[i2];
            while (e2 != null) {
                if (e2.value == null) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        KeyComparatorHashMap result = null;
        try {
            result = (KeyComparatorHashMap)super.clone();
            result.table = new Entry[this.table.length];
            result.entrySet = null;
            result.modCount = 0;
            result.size = 0;
            result.init();
            result.putAllForCreate(this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e2 = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e2);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e2 = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e2);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es2 = this.entrySet;
        return es2 != null ? es2 : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        Iterator<Map.Entry<K, V>> i2 = this.entrySet().iterator();
        s2.defaultWriteObject();
        s2.writeInt(this.table.length);
        s2.writeInt(this.size);
        while (i2.hasNext()) {
            Map.Entry<K, V> e2 = i2.next();
            s2.writeObject(e2.getKey());
            s2.writeObject(e2.getValue());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int numBuckets = s2.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int ss = s2.readInt();
        for (int i2 = 0; i2 < ss; ++i2) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return KeyComparatorHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Entry candidate = KeyComparatorHashMap.this.getEntry(e2.getKey());
            return candidate != null && candidate.equals(e2);
        }

        @Override
        public boolean remove(Object o2) {
            return KeyComparatorHashMap.this.removeMapping(o2) != null;
        }

        @Override
        public int size() {
            return KeyComparatorHashMap.this.size;
        }

        @Override
        public void clear() {
            KeyComparatorHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = KeyComparatorHashMap.this.modCount;
            Entry<K, V>[] t2 = KeyComparatorHashMap.this.table;
            int i2 = t2.length;
            Entry n2 = null;
            if (KeyComparatorHashMap.this.size != 0) {
                while (i2 > 0 && (n2 = t2[--i2]) == null) {
                }
            }
            this.next = n2;
            this.index = i2;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<K, V> nextEntry() {
            if (KeyComparatorHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e2 = this.next;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            Entry n2 = e2.next;
            Entry<K, V>[] t2 = KeyComparatorHashMap.this.table;
            int i2 = this.index;
            while (n2 == null && i2 > 0) {
                n2 = t2[--i2];
            }
            this.index = i2;
            this.next = n2;
            this.current = e2;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (KeyComparatorHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k2 = this.current.key;
            this.current = null;
            KeyComparatorHashMap.this.removeEntryForKey(k2);
            this.expectedModCount = KeyComparatorHashMap.this.modCount;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(int h2, K k2, V v2, Entry<K, V> n2) {
            this.value = v2;
            this.next = n2;
            this.key = k2;
            this.hash = h2;
        }

        @Override
        public K getKey() {
            return KeyComparatorHashMap.unmaskNull(this.key);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o2) {
            Object v2;
            V v1;
            Object k2;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            K k1 = this.getKey();
            return (k1 == (k2 = e2.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e2.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(KeyComparatorHashMap<K, V> m3) {
        }

        void recordRemoval(KeyComparatorHashMap<K, V> m3) {
        }
    }
}

