/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.grizzly.AbstractBindingHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Exceptions;

public class UDPNIOBindingHandler
extends AbstractBindingHandler {
    private final UDPNIOTransport udpTransport;

    public UDPNIOBindingHandler(UDPNIOTransport udpTransport) {
        super(udpTransport);
        this.udpTransport = udpTransport;
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, -1);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindToChannel(this.udpTransport.getSelectorProvider().openDatagramChannel(), socketAddress);
    }

    @Override
    public UDPNIOServerConnection bindToInherited() throws IOException {
        return this.bindToChannel((DatagramChannel)this.getSystemInheritedChannel(DatagramChannel.class), null);
    }

    @Override
    public void unbind(Connection connection) {
        this.udpTransport.unbind(connection);
    }

    public static Builder builder(UDPNIOTransport transport) {
        return new Builder().transport(transport);
    }

    private UDPNIOServerConnection bindToChannel(DatagramChannel serverDatagramChannel, SocketAddress socketAddress) throws IOException {
        NIOConnection serverConnection = null;
        ReentrantReadWriteLock.WriteLock lock = this.udpTransport.getState().getStateLocker().writeLock();
        lock.lock();
        try {
            Object socket;
            this.udpTransport.getChannelConfigurator().preConfigure(this.transport, serverDatagramChannel);
            if (socketAddress != null) {
                socket = serverDatagramChannel.socket();
                ((DatagramSocket)socket).bind(socketAddress);
            }
            this.udpTransport.getChannelConfigurator().postConfigure(this.transport, serverDatagramChannel);
            serverConnection = this.udpTransport.obtainServerNIOConnection(serverDatagramChannel);
            serverConnection.setProcessor(this.getProcessor());
            serverConnection.setProcessorSelector(this.getProcessorSelector());
            this.udpTransport.serverConnections.add((UDPNIOServerConnection)serverConnection);
            if (!this.udpTransport.isStopped()) {
                ((UDPNIOServerConnection)serverConnection).register();
            }
            socket = serverConnection;
            return socket;
        }
        catch (Exception e2) {
            if (serverConnection != null) {
                this.udpTransport.serverConnections.remove(serverConnection);
                serverConnection.closeSilently();
            } else {
                try {
                    serverDatagramChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e2);
        }
        finally {
            lock.unlock();
        }
    }

    public static class Builder
    extends AbstractBindingHandler.Builder<Builder> {
        private UDPNIOTransport transport;

        @Override
        public UDPNIOBindingHandler build() {
            return (UDPNIOBindingHandler)super.build();
        }

        public Builder transport(UDPNIOTransport transport) {
            this.transport = transport;
            return this;
        }

        @Override
        protected AbstractBindingHandler create() {
            if (this.transport == null) {
                throw new IllegalStateException("Unable to create TCPNIOBindingHandler - transport is null");
            }
            return new UDPNIOBindingHandler(this.transport);
        }
    }
}

