/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.grizzly.AbstractBindingHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.Exceptions;

public class TCPNIOBindingHandler
extends AbstractBindingHandler {
    private final TCPNIOTransport tcpTransport;

    TCPNIOBindingHandler(TCPNIOTransport tcpTransport) {
        super(tcpTransport);
        this.tcpTransport = tcpTransport;
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, this.tcpTransport.getServerConnectionBackLog());
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindToChannelAndAddress(this.tcpTransport.getSelectorProvider().openServerSocketChannel(), socketAddress, backlog);
    }

    @Override
    public TCPNIOServerConnection bindToInherited() throws IOException {
        return this.bindToChannelAndAddress((ServerSocketChannel)this.getSystemInheritedChannel(ServerSocketChannel.class), null, -1);
    }

    @Override
    public void unbind(Connection connection) {
        this.tcpTransport.unbind(connection);
    }

    public static Builder builder(TCPNIOTransport transport) {
        return new Builder().transport(transport);
    }

    private TCPNIOServerConnection bindToChannelAndAddress(ServerSocketChannel serverSocketChannel, SocketAddress socketAddress, int backlog) throws IOException {
        NIOConnection serverConnection = null;
        ReentrantReadWriteLock.WriteLock lock = this.tcpTransport.getState().getStateLocker().writeLock();
        lock.lock();
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            this.tcpTransport.getChannelConfigurator().preConfigure(this.transport, serverSocketChannel);
            if (socketAddress != null) {
                serverSocket.bind(socketAddress, backlog);
            }
            this.tcpTransport.getChannelConfigurator().postConfigure(this.transport, serverSocketChannel);
            serverConnection = this.tcpTransport.obtainServerNIOConnection(serverSocketChannel);
            serverConnection.setProcessor(this.getProcessor());
            serverConnection.setProcessorSelector(this.getProcessorSelector());
            this.tcpTransport.serverConnections.add((TCPNIOServerConnection)serverConnection);
            ((TCPNIOServerConnection)serverConnection).resetProperties();
            if (!this.tcpTransport.isStopped()) {
                this.tcpTransport.listenServerConnection((TCPNIOServerConnection)serverConnection);
            }
            NIOConnection nIOConnection = serverConnection;
            return nIOConnection;
        }
        catch (Exception e2) {
            if (serverConnection != null) {
                this.tcpTransport.serverConnections.remove(serverConnection);
                serverConnection.closeSilently();
            } else {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e2);
        }
        finally {
            lock.unlock();
        }
    }

    public static class Builder
    extends AbstractBindingHandler.Builder<Builder> {
        private TCPNIOTransport transport;

        public Builder transport(TCPNIOTransport transport) {
            this.transport = transport;
            return this;
        }

        @Override
        public TCPNIOBindingHandler build() {
            return (TCPNIOBindingHandler)super.build();
        }

        @Override
        protected AbstractBindingHandler create() {
            if (this.transport == null) {
                throw new IllegalStateException("Unable to create TCPNIOBindingHandler - transport is null");
            }
            return new TCPNIOBindingHandler(this.transport);
        }
    }
}

