/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

class Bits {
    private Bits() {
    }

    static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    static char getCharL(byte[] bb2, int bi2) {
        return Bits.makeChar(bb2[bi2 + 1], bb2[bi2]);
    }

    static char getCharB(byte[] bb2, int bi2) {
        return Bits.makeChar(bb2[bi2], bb2[bi2 + 1]);
    }

    static char getChar(byte[] bb2, int bi2, boolean bigEndian) {
        return bigEndian ? Bits.getCharB(bb2, bi2) : Bits.getCharL(bb2, bi2);
    }

    static byte char1(char x2) {
        return (byte)(x2 >> 8);
    }

    static byte char0(char x2) {
        return (byte)x2;
    }

    static void putCharL(byte[] bb2, int bi2, char x2) {
        bb2[bi2] = Bits.char0(x2);
        bb2[bi2 + 1] = Bits.char1(x2);
    }

    static void putCharB(byte[] bb2, int bi2, char x2) {
        bb2[bi2] = Bits.char1(x2);
        bb2[bi2 + 1] = Bits.char0(x2);
    }

    static void putChar(byte[] bb2, int bi2, char x2, boolean bigEndian) {
        if (bigEndian) {
            Bits.putCharB(bb2, bi2, x2);
        } else {
            Bits.putCharL(bb2, bi2, x2);
        }
    }

    static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    static short getShortL(byte[] bb2, int bi2) {
        return Bits.makeShort(bb2[bi2 + 1], bb2[bi2]);
    }

    static short getShortB(byte[] bb2, int bi2) {
        return Bits.makeShort(bb2[bi2], bb2[bi2 + 1]);
    }

    static short getShort(byte[] bb2, int bi2, boolean bigEndian) {
        return bigEndian ? Bits.getShortB(bb2, bi2) : Bits.getShortL(bb2, bi2);
    }

    static byte short1(short x2) {
        return (byte)(x2 >> 8);
    }

    static byte short0(short x2) {
        return (byte)x2;
    }

    static void putShortL(byte[] bb2, int bi2, short x2) {
        bb2[bi2] = Bits.short0(x2);
        bb2[bi2 + 1] = Bits.short1(x2);
    }

    static void putShortB(byte[] bb2, int bi2, short x2) {
        bb2[bi2] = Bits.short1(x2);
        bb2[bi2 + 1] = Bits.short0(x2);
    }

    static void putShort(byte[] bb2, int bi2, short x2, boolean bigEndian) {
        if (bigEndian) {
            Bits.putShortB(bb2, bi2, x2);
        } else {
            Bits.putShortL(bb2, bi2, x2);
        }
    }

    static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    static int getIntL(byte[] bb2, int bi2) {
        return Bits.makeInt(bb2[bi2 + 3], bb2[bi2 + 2], bb2[bi2 + 1], bb2[bi2]);
    }

    static int getIntB(byte[] bb2, int bi2) {
        return Bits.makeInt(bb2[bi2], bb2[bi2 + 1], bb2[bi2 + 2], bb2[bi2 + 3]);
    }

    static int getInt(byte[] bb2, int bi2, boolean bigEndian) {
        return bigEndian ? Bits.getIntB(bb2, bi2) : Bits.getIntL(bb2, bi2);
    }

    static byte int3(int x2) {
        return (byte)(x2 >> 24);
    }

    static byte int2(int x2) {
        return (byte)(x2 >> 16);
    }

    static byte int1(int x2) {
        return (byte)(x2 >> 8);
    }

    static byte int0(int x2) {
        return (byte)x2;
    }

    static void putIntL(byte[] bb2, int bi2, int x2) {
        bb2[bi2 + 3] = Bits.int3(x2);
        bb2[bi2 + 2] = Bits.int2(x2);
        bb2[bi2 + 1] = Bits.int1(x2);
        bb2[bi2] = Bits.int0(x2);
    }

    static void putIntB(byte[] bb2, int bi2, int x2) {
        bb2[bi2] = Bits.int3(x2);
        bb2[bi2 + 1] = Bits.int2(x2);
        bb2[bi2 + 2] = Bits.int1(x2);
        bb2[bi2 + 3] = Bits.int0(x2);
    }

    static void putInt(byte[] bb2, int bi2, int x2, boolean bigEndian) {
        if (bigEndian) {
            Bits.putIntB(bb2, bi2, x2);
        } else {
            Bits.putIntL(bb2, bi2, x2);
        }
    }

    static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    static long getLongL(byte[] bb2, int bi2) {
        return Bits.makeLong(bb2[bi2 + 7], bb2[bi2 + 6], bb2[bi2 + 5], bb2[bi2 + 4], bb2[bi2 + 3], bb2[bi2 + 2], bb2[bi2 + 1], bb2[bi2]);
    }

    static long getLongB(byte[] bb2, int bi2) {
        return Bits.makeLong(bb2[bi2], bb2[bi2 + 1], bb2[bi2 + 2], bb2[bi2 + 3], bb2[bi2 + 4], bb2[bi2 + 5], bb2[bi2 + 6], bb2[bi2 + 7]);
    }

    static long getLong(byte[] bb2, int bi2, boolean bigEndian) {
        return bigEndian ? Bits.getLongB(bb2, bi2) : Bits.getLongL(bb2, bi2);
    }

    static byte long7(long x2) {
        return (byte)(x2 >> 56);
    }

    static byte long6(long x2) {
        return (byte)(x2 >> 48);
    }

    static byte long5(long x2) {
        return (byte)(x2 >> 40);
    }

    static byte long4(long x2) {
        return (byte)(x2 >> 32);
    }

    static byte long3(long x2) {
        return (byte)(x2 >> 24);
    }

    static byte long2(long x2) {
        return (byte)(x2 >> 16);
    }

    static byte long1(long x2) {
        return (byte)(x2 >> 8);
    }

    static byte long0(long x2) {
        return (byte)x2;
    }

    static void putLongL(byte[] bb2, int bi2, long x2) {
        bb2[bi2 + 7] = Bits.long7(x2);
        bb2[bi2 + 6] = Bits.long6(x2);
        bb2[bi2 + 5] = Bits.long5(x2);
        bb2[bi2 + 4] = Bits.long4(x2);
        bb2[bi2 + 3] = Bits.long3(x2);
        bb2[bi2 + 2] = Bits.long2(x2);
        bb2[bi2 + 1] = Bits.long1(x2);
        bb2[bi2] = Bits.long0(x2);
    }

    static void putLongB(byte[] bb2, int bi2, long x2) {
        bb2[bi2] = Bits.long7(x2);
        bb2[bi2 + 1] = Bits.long6(x2);
        bb2[bi2 + 2] = Bits.long5(x2);
        bb2[bi2 + 3] = Bits.long4(x2);
        bb2[bi2 + 4] = Bits.long3(x2);
        bb2[bi2 + 5] = Bits.long2(x2);
        bb2[bi2 + 6] = Bits.long1(x2);
        bb2[bi2 + 7] = Bits.long0(x2);
    }

    static void putLong(byte[] bb2, int bi2, long x2, boolean bigEndian) {
        if (bigEndian) {
            Bits.putLongB(bb2, bi2, x2);
        } else {
            Bits.putLongL(bb2, bi2, x2);
        }
    }

    static float getFloatL(byte[] bb2, int bi2) {
        return Float.intBitsToFloat(Bits.getIntL(bb2, bi2));
    }

    static float getFloatB(byte[] bb2, int bi2) {
        return Float.intBitsToFloat(Bits.getIntB(bb2, bi2));
    }

    static float getFloat(byte[] bb2, int bi2, boolean bigEndian) {
        return bigEndian ? Bits.getFloatB(bb2, bi2) : Bits.getFloatL(bb2, bi2);
    }

    static void putFloatL(byte[] bb2, int bi2, float x2) {
        Bits.putIntL(bb2, bi2, Float.floatToRawIntBits(x2));
    }

    static void putFloatB(byte[] bb2, int bi2, float x2) {
        Bits.putIntB(bb2, bi2, Float.floatToRawIntBits(x2));
    }

    static void putFloat(byte[] bb2, int bi2, float x2, boolean bigEndian) {
        if (bigEndian) {
            Bits.putFloatB(bb2, bi2, x2);
        } else {
            Bits.putFloatL(bb2, bi2, x2);
        }
    }

    static double getDoubleL(byte[] bb2, int bi2) {
        return Double.longBitsToDouble(Bits.getLongL(bb2, bi2));
    }

    static double getDoubleB(byte[] bb2, int bi2) {
        return Double.longBitsToDouble(Bits.getLongB(bb2, bi2));
    }

    static double getDouble(byte[] bb2, int bi2, boolean bigEndian) {
        return bigEndian ? Bits.getDoubleB(bb2, bi2) : Bits.getDoubleL(bb2, bi2);
    }

    static void putDoubleL(byte[] bb2, int bi2, double x2) {
        Bits.putLongL(bb2, bi2, Double.doubleToRawLongBits(x2));
    }

    static void putDoubleB(byte[] bb2, int bi2, double x2) {
        Bits.putLongB(bb2, bi2, Double.doubleToRawLongBits(x2));
    }

    static void putDouble(byte[] bb2, int bi2, double x2, boolean bigEndian) {
        if (bigEndian) {
            Bits.putDoubleB(bb2, bi2, x2);
        } else {
            Bits.putDoubleL(bb2, bi2, x2);
        }
    }
}

