/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.util.Arrays;
import java.util.Iterator;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaderField;
import org.glassfish.grizzly.http.util.NamesIterator;
import org.glassfish.grizzly.http.util.ValuesIterator;

public class MimeHeaders {
    private static final String[] INVALID_TRAILER_NAMES = new String[]{Header.CacheControl.getLowerCase(), Header.Expect.getLowerCase(), Header.Host.getLowerCase(), Header.MaxForwards.getLowerCase(), Header.Pragma.getLowerCase(), Header.Range.getLowerCase(), Header.TE.getLowerCase(), Header.SetCookie.getLowerCase(), Header.Authorization.getLowerCase(), Header.WWWAuthenticate.getLowerCase(), Header.ProxyAuthenticate.getLowerCase(), Header.ProxyAuthorization.getLowerCase(), Header.Age.getLowerCase(), Header.Date.getLowerCase(), Header.Location.getLowerCase(), Header.RetryAfter.getLowerCase(), Header.Vary.getLowerCase(), Header.Warnings.getLowerCase(), Header.IfMatch.getLowerCase(), Header.IfNoneMatch.getLowerCase(), Header.IfModifiedSince.getLowerCase(), Header.IfUnmodifiedSince.getLowerCase(), Header.IfRange.getLowerCase()};
    public static final int MAX_NUM_HEADERS_UNBOUNDED = -1;
    public static final int MAX_NUM_HEADERS_DEFAULT = 100;
    public static final int DEFAULT_HEADER_SIZE = 8;
    public static DataChunk NOOP_CHUNK;
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private boolean marked;
    protected int mark;
    private int maxNumHeaders = 100;
    private final Iterable<String> namesIterable = new Iterable<String>(){

        @Override
        public Iterator<String> iterator() {
            return new NamesIterator(MimeHeaders.this, false);
        }
    };

    public void mark() {
        if (!this.marked) {
            this.marked = true;
            this.mark = this.count;
        }
    }

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.headers[i2].recycle();
        }
        this.count = 0;
        this.mark = 0;
        this.marked = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== MimeHeaders ===\n");
        for (int i2 = 0; i2 < this.count; ++i2) {
            sb.append(this.headers[i2].nameB).append(" = ").append(this.headers[i2].valueB).append('\n');
        }
        return sb.toString();
    }

    public void copyFrom(MimeHeaders source2) {
        if (source2 == null || source2.size() == 0) {
            return;
        }
        this.maxNumHeaders = source2.maxNumHeaders;
        this.count = source2.count;
        if (this.headers.length < this.count) {
            MimeHeaderField[] tmp = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, tmp, 0, this.headers.length);
            this.headers = tmp;
        }
        int len = source2.count;
        for (int i2 = 0; i2 < len; ++i2) {
            MimeHeaderField sourceField = source2.headers[i2];
            if (!this.isValidName(sourceField.getName().toString())) continue;
            MimeHeaderField f2 = this.headers[i2];
            if (f2 == null) {
                this.headers[i2] = f2 = new MimeHeaderField();
            }
            if (sourceField.nameB.type == DataChunk.Type.Buffer) {
                MimeHeaders.copyBufferChunk(sourceField.nameB, f2.nameB);
            } else {
                f2.nameB.set(sourceField.nameB);
            }
            if (sourceField.valueB.type == DataChunk.Type.Buffer) {
                MimeHeaders.copyBufferChunk(sourceField.valueB, f2.valueB);
                continue;
            }
            f2.valueB.set(sourceField.valueB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyBufferChunk(DataChunk source2, DataChunk dest) {
        BufferChunk bc2 = source2.getBufferChunk();
        int l2 = bc2.getLength();
        byte[] bytes = new byte[l2];
        Buffer b2 = bc2.getBuffer();
        int oldPos = b2.position();
        try {
            b2.position(bc2.getStart());
            bc2.getBuffer().get(bytes, 0, l2);
            dest.setBytes(bytes);
        }
        finally {
            b2.position(oldPos);
        }
    }

    public int size() {
        return this.count;
    }

    public int trailerSize() {
        return this.marked ? this.count - this.mark : 0;
    }

    public DataChunk getName(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2].getName() : null;
    }

    public DataChunk getValue(int n2) {
        return n2 >= 0 && n2 < this.count ? this.headers[n2].getValue() : null;
    }

    public boolean isSerialized(int n2) {
        if (n2 >= 0 && n2 < this.count) {
            MimeHeaderField field = this.headers[n2];
            return field.isSerialized();
        }
        return false;
    }

    public boolean setSerialized(int n2, boolean newValue) {
        boolean value;
        if (n2 >= 0 && n2 < this.count) {
            MimeHeaderField field = this.headers[n2];
            value = field.isSerialized();
            field.setSerialized(newValue);
        } else {
            value = true;
        }
        return value;
    }

    public int indexOf(String name, int fromIndex) {
        for (int i2 = fromIndex; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(Header header, int fromIndex) {
        byte[] bytes = header.getLowerCaseBytes();
        for (int i2 = fromIndex; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
            return i2;
        }
        return -1;
    }

    public boolean contains(Header header) {
        return this.indexOf(header, 0) >= 0;
    }

    public boolean contains(String header) {
        return this.indexOf(header, 0) >= 0;
    }

    public Iterable<String> names() {
        return this.namesIterable;
    }

    public Iterable<String> trailerNames() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new NamesIterator(MimeHeaders.this, true);
            }
        };
    }

    public Iterable<String> values(final String name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name, false);
            }
        };
    }

    public Iterable<String> values(Header name) {
        return this.values(name.toString());
    }

    public Iterable<String> trailerValues(final String name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name, true);
            }
        };
    }

    public Iterable<String> trailerValues(Header name) {
        return this.trailerValues(name.toString());
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        if (this.maxNumHeaders >= 0 && this.count == this.maxNumHeaders) {
            throw new MaxHeaderCountExceededException();
        }
        int len = this.headers.length;
        if (this.count >= len) {
            int newCount = this.count * 2;
            if (this.maxNumHeaders >= 0 && newCount > this.maxNumHeaders) {
                newCount = this.maxNumHeaders;
            }
            MimeHeaderField[] tmp = new MimeHeaderField[newCount];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public DataChunk addValue(String name) {
        if (!this.isValidName(name)) {
            return NOOP_CHUNK;
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk addValue(Header header) {
        if (!this.isValidName(header)) {
            return NOOP_CHUNK;
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setBytes(header.toByteArray());
        return mh.getValue();
    }

    public DataChunk addValue(byte[] buffer, int startN, int len) {
        if (!this.isValidName(buffer)) {
            return NOOP_CHUNK;
        }
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(buffer, startN, startN + len);
        return mhf.getValue();
    }

    public DataChunk addValue(Buffer buffer, int startN, int len) {
        if (!this.isValidName(buffer)) {
            return NOOP_CHUNK;
        }
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBuffer(buffer, startN, startN + len);
        return mhf.getValue();
    }

    public DataChunk setValue(String name) {
        if (!this.isValidName(name)) {
            return NOOP_CHUNK;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            for (int j2 = i2 + 1; j2 < this.count; ++j2) {
                if (!this.headers[j2].getName().equalsIgnoreCase(name)) continue;
                this.removeHeader(j2--);
            }
            return this.headers[i2].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk setValue(Header header) {
        if (!this.isValidName(header)) {
            return NOOP_CHUNK;
        }
        byte[] bytes = header.getLowerCaseBytes();
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
            for (int j2 = i2 + 1; j2 < this.count; ++j2) {
                if (!this.headers[j2].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
                this.removeHeader(j2--);
            }
            return this.headers[i2].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setBytes(header.toByteArray());
        return mh.getValue();
    }

    public DataChunk getValue(String name) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            return this.headers[i2].getValue();
        }
        return null;
    }

    public DataChunk getValue(Header header) {
        byte[] bytes = header.getLowerCaseBytes();
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
            return this.headers[i2].getValue();
        }
        return null;
    }

    public String getHeader(String name) {
        DataChunk mh = this.getValue(name);
        return mh != null ? mh.toString() : null;
    }

    public String getHeader(Header header) {
        DataChunk mh = this.getValue(header);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name)) continue;
            this.removeHeader(i2--);
        }
    }

    public void removeHeader(Header header) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(header.getBytes())) continue;
            this.removeHeader(i2--);
        }
    }

    public void removeHeader(String name, String str) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name) || this.getValue(i2) == null || this.getValue(i2).toString() == null || !this.getValue(i2).toString().contains(str)) continue;
            this.removeHeader(i2--);
        }
    }

    public void removeHeaderMatches(String name, String regex) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCase(name) || this.getValue(i2) == null || this.getValue(i2).toString() == null || !this.getValue(i2).toString().matches(regex)) continue;
            this.removeHeader(i2--);
        }
    }

    public void removeHeaderMatches(Header header, String regex) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.headers[i2].getName().equalsIgnoreCaseLowerCase(header.getLowerCaseBytes()) || this.getValue(i2) == null || this.getValue(i2).toString() == null || !this.getValue(i2).toString().matches(regex)) continue;
            this.removeHeader(i2--);
        }
    }

    void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        this.headers[idx] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mh;
        --this.count;
    }

    public void setMaxNumHeaders(int maxNumHeaders) {
        this.maxNumHeaders = maxNumHeaders;
    }

    public int getMaxNumHeaders() {
        return this.maxNumHeaders;
    }

    private boolean isValidName(String name) {
        return !this.marked || Arrays.binarySearch(INVALID_TRAILER_NAMES, name.toLowerCase()) < 0;
    }

    private boolean isValidName(Header name) {
        return !this.marked || Arrays.binarySearch(INVALID_TRAILER_NAMES, name.getLowerCase()) < 0;
    }

    private boolean isValidName(byte[] name) {
        return !this.marked || Arrays.binarySearch(INVALID_TRAILER_NAMES, new String(name).toLowerCase()) < 0;
    }

    private boolean isValidName(Buffer name) {
        return !this.marked || Arrays.binarySearch(INVALID_TRAILER_NAMES, name.toStringContent().toLowerCase()) < 0;
    }

    static {
        Arrays.sort(INVALID_TRAILER_NAMES);
        NOOP_CHUNK = new DataChunk.Immutable(null);
    }

    public class MaxHeaderCountExceededException
    extends IllegalStateException {
        public MaxHeaderCountExceededException() {
            super("Illegal attempt to exceed the configured maximum number of headers: " + MimeHeaders.this.maxNumHeaders);
        }
    }
}

