/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.utils.Charsets;

public class HttpUtils {
    private static final float[] MULTIPLIERS = new float[]{0.1f, 0.01f, 0.001f};

    public static String composeContentType(String contentType, String characterEncoding) {
        String newContentType;
        if (characterEncoding == null) {
            return contentType;
        }
        boolean hasCharset = false;
        int semicolonIndex = -1;
        int index = contentType.indexOf(59);
        while (index != -1) {
            int len = contentType.length();
            semicolonIndex = index++;
            while (index < len && contentType.charAt(index) == ' ') {
                ++index;
            }
            if (index + 8 < len && contentType.charAt(index) == 'c' && contentType.charAt(index + 1) == 'h' && contentType.charAt(index + 2) == 'a' && contentType.charAt(index + 3) == 'r' && contentType.charAt(index + 4) == 's' && contentType.charAt(index + 5) == 'e' && contentType.charAt(index + 6) == 't' && contentType.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = contentType.indexOf(59, index);
        }
        if (hasCharset) {
            newContentType = contentType.substring(0, semicolonIndex);
            String tail = contentType.substring(index + 8);
            int nextParam = tail.indexOf(59);
            if (nextParam != -1) {
                newContentType = newContentType + tail.substring(nextParam);
            }
        } else {
            newContentType = contentType;
        }
        StringBuilder sb = new StringBuilder(newContentType.length() + characterEncoding.length() + 9);
        return sb.append(newContentType).append(";charset=").append(characterEncoding).toString();
    }

    public static float convertQValueToFloat(DataChunk dc2, int startIdx, int stopIdx) {
        float qvalue = 0.0f;
        DataChunk.Type type = dc2.getType();
        try {
            switch (type) {
                case String: {
                    qvalue = HttpUtils.convertQValueToFloat(dc2.toString(), startIdx, stopIdx);
                    break;
                }
                case Buffer: {
                    BufferChunk bc2 = dc2.getBufferChunk();
                    int offs = bc2.getStart();
                    qvalue = HttpUtils.convertQValueToFloat(bc2.getBuffer(), offs + startIdx, offs + stopIdx);
                    break;
                }
                case Chars: {
                    CharChunk cc2 = dc2.getCharChunk();
                    int offs = cc2.getStart();
                    qvalue = HttpUtils.convertQValueToFloat(cc2.getChars(), offs + startIdx, offs + stopIdx);
                }
            }
        }
        catch (Exception e2) {
            qvalue = 0.0f;
        }
        return qvalue;
    }

    public static float convertQValueToFloat(Buffer buffer, int startIdx, int stopIdx) {
        float result = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = (char)buffer.get(i2 + startIdx);
            if (multIdx == -1) {
                if (firstDigitProcessed && c2 != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                if (c2 == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c2)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c2, 10);
                    firstDigitProcessed = true;
                    if (!(result > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                result += (float)Character.digit(c2, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
        }
        return result;
    }

    public static float convertQValueToFloat(String string, int startIdx, int stopIdx) {
        float result = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = string.charAt(i2 + startIdx);
            if (multIdx == -1) {
                if (firstDigitProcessed && c2 != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                if (c2 == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c2)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c2, 10);
                    firstDigitProcessed = true;
                    if (!(result > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                result += (float)Character.digit(c2, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
        }
        return result;
    }

    public static float convertQValueToFloat(char[] chars, int startIdx, int stopIdx) {
        float result = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = chars[i2 + startIdx];
            if (multIdx == -1) {
                if (firstDigitProcessed && c2 != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                if (c2 == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c2)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c2, 10);
                    firstDigitProcessed = true;
                    if (!(result > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                result += (float)Character.digit(c2, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
        }
        return result;
    }

    public static int longToBuffer(long value, byte[] buffer) {
        boolean negative;
        int i2 = buffer.length;
        if (value == 0L) {
            buffer[--i2] = 48;
            return i2;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        do {
            int ch2 = 48 + (int)(value % 10L);
            buffer[--i2] = (byte)ch2;
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer[--i2] = 45;
        }
        return i2;
    }

    public static void longToBuffer(long value, Buffer buffer) {
        boolean negative;
        if (value == 0L) {
            buffer.put(0, (byte)48);
            buffer.limit(1);
            return;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        int position = buffer.limit();
        do {
            int ch2 = 48 + (int)(value % 10L);
            buffer.put(--position, (byte)ch2);
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer.put(--position, (byte)45);
        }
        buffer.position(position);
    }

    public static DataChunk filterNonPrintableCharacters(DataChunk message) {
        if (message == null || message.isNull()) {
            return null;
        }
        try {
            message.toChars(Charsets.ASCII_CHARSET);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        CharChunk charChunk = message.getCharChunk();
        char[] content = charChunk.getChars();
        int start = charChunk.getStart();
        int end = charChunk.getEnd();
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = content[i2];
            if ((c2 > '\u001f' || c2 == '\t') && c2 != '\u007f' && c2 <= '\u00ff') continue;
            content[i2] = 32;
        }
        return message;
    }

    public static DataChunk filter(DataChunk message) {
        if (message == null || message.isNull()) {
            return null;
        }
        try {
            message.toChars(Charsets.ASCII_CHARSET);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        CharChunk charChunk = message.getCharChunk();
        char[] content = charChunk.getChars();
        StringBuilder result = null;
        int end = charChunk.getEnd();
        block8: for (int i2 = charChunk.getStart(); i2 < end; ++i2) {
            switch (content[i2]) {
                case '<': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i2);
                    }
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i2);
                    }
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i2);
                    }
                    result.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i2);
                    }
                    result.append("&quot;");
                    continue block8;
                }
                default: {
                    char c2 = content[i2];
                    if (c2 <= '\u001f' && c2 != '\t' || c2 == '\u007f' || c2 > '\u00ff') {
                        if (result == null) {
                            result = new StringBuilder(content.length + 50);
                            result.append(content, 0, i2);
                        }
                        result.append("&#").append((int)c2).append(';');
                        continue block8;
                    }
                    if (result == null) continue block8;
                    result.append(c2);
                }
            }
        }
        if (result != null) {
            int len = result.length();
            char[] finalResult = new char[len];
            result.getChars(0, len, finalResult, 0);
            message.setChars(finalResult, 0, finalResult.length);
        }
        return message;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        StringBuilder result = null;
        int len = message.length();
        block6: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = message.charAt(i2);
            switch (c2) {
                case '<': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i2);
                    }
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i2);
                    }
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i2);
                    }
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i2);
                    }
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    if (c2 <= '\u001f' && c2 != '\t' || c2 == '\u007f' || c2 > '\u00ff') {
                        if (result == null) {
                            result = new StringBuilder(len + 50);
                            result.append(message, 0, i2);
                        }
                        result.append("&#").append((int)c2).append(';');
                        continue block6;
                    }
                    if (result == null) continue block6;
                    result.append(c2);
                }
            }
        }
        return result == null ? message : result.toString();
    }
}

