/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.ByteArrayOutputStream;

public final class HexUtils {
    static final boolean[] IS_HEX_DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final int[] DEC = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static byte[] convert(String digits) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < digits.length(); i2 += 2) {
            char c1 = digits.charAt(i2);
            if (i2 + 1 >= digits.length()) {
                throw new IllegalArgumentException("hexUtil.odd");
            }
            char c2 = digits.charAt(i2 + 1);
            int b2 = 0;
            if (c1 >= '0' && c1 <= '9') {
                b2 = (byte)(b2 + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b2 = (byte)(b2 + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b2 = (byte)(b2 + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException("hexUtil.bad");
            }
            if (c2 >= '0' && c2 <= '9') {
                b2 = (byte)(b2 + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b2 = (byte)(b2 + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b2 = (byte)(b2 + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException("hexUtil.bad");
            }
            baos.write(b2);
        }
        return baos.toByteArray();
    }

    public static String convert(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            sb.append(HexUtils.convertDigit(bytes[i2] >> 4));
            sb.append(HexUtils.convertDigit(bytes[i2] & 0xF));
        }
        return sb.toString();
    }

    public static int convert2Int(byte[] hex) {
        if (hex.length < 4) {
            return 0;
        }
        if (DEC[hex[0]] < 0) {
            throw new IllegalArgumentException("hexUtil.bad");
        }
        int len = DEC[hex[0]];
        len <<= 4;
        if (DEC[hex[1]] < 0) {
            throw new IllegalArgumentException("hexUtil.bad");
        }
        len += DEC[hex[1]];
        len <<= 4;
        if (DEC[hex[2]] < 0) {
            throw new IllegalArgumentException("hexUtil.bad");
        }
        len += DEC[hex[2]];
        len <<= 4;
        if (DEC[hex[3]] < 0) {
            throw new IllegalArgumentException("hexUtil.bad");
        }
        return len += DEC[hex[3]];
    }

    public static int[] getDecBytes() {
        return (int[])DEC.clone();
    }

    private static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }

    public static boolean isHexDigit(byte c2) {
        return IS_HEX_DIGIT[c2];
    }

    public static boolean isHexDigit(int c2) {
        return IS_HEX_DIGIT[c2];
    }

    public static int hexDigit2Dec(byte hexDigit) {
        return DEC[hexDigit];
    }

    public static int hexDigit2Dec(int hexDigit) {
        return DEC[hexDigit];
    }
}

