/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Chunk;
import org.glassfish.grizzly.http.util.Constants;

public final class ByteChunk
implements Chunk,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final Charset DEFAULT_CHARSET = Constants.DEFAULT_HTTP_CHARSET;
    private byte[] buff;
    private int start = 0;
    private int end;
    private Charset charset;
    private boolean isSet = false;
    private int limit = -1;
    private transient ByteInputChannel in = null;
    private transient ByteOutputChannel out = null;
    private boolean optimizedWrite = true;
    private String cachedString;
    private Charset cachedStringCharset;

    public ByteChunk() {
    }

    public ByteChunk(int initial) {
        this.allocate(initial, -1);
    }

    public ByteChunk getClone() {
        try {
            return (ByteChunk)this.clone();
        }
        catch (Exception ex2) {
            return null;
        }
    }

    public boolean isNull() {
        return !this.isSet;
    }

    public void recycle() {
        this.charset = null;
        this.start = 0;
        this.end = 0;
        this.isSet = false;
    }

    public void recycleAndReset() {
        this.buff = null;
        this.charset = null;
        this.start = 0;
        this.end = 0;
        this.isSet = false;
        this.resetStringCache();
    }

    public void reset() {
        this.buff = null;
        this.resetStringCache();
    }

    protected final void resetStringCache() {
        this.cachedString = null;
        this.cachedStringCharset = null;
    }

    public void allocate(int initial, int limit) {
        boolean output = true;
        if (this.buff == null || this.buff.length < initial) {
            this.buff = new byte[initial];
        }
        this.limit = limit;
        this.start = 0;
        this.end = 0;
        this.isSet = true;
        this.resetStringCache();
    }

    public void setBytes(byte[] b2, int off, int len) {
        this.buff = b2;
        this.start = off;
        this.end = this.start + len;
        this.isSet = true;
        this.resetStringCache();
    }

    public void setOptimizedWrite(boolean optimizedWrite) {
        this.optimizedWrite = optimizedWrite;
    }

    public Charset getCharset() {
        return this.charset != null ? this.charset : DEFAULT_CHARSET;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
        this.resetStringCache();
    }

    public byte[] getBytes() {
        return this.getBuffer();
    }

    public byte[] getBuffer() {
        return this.buff;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.getStart();
    }

    @Override
    public void setStart(int start) {
        if (this.end < start) {
            this.end = start;
        }
        this.start = start;
        this.resetStringCache();
    }

    public void setOffset(int off) {
        this.setStart(off);
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.resetStringCache();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setByteInputChannel(ByteInputChannel in2) {
        this.in = in2;
    }

    public void setByteOutputChannel(ByteOutputChannel out) {
        this.out = out;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int i2) {
        this.end = i2;
        this.resetStringCache();
    }

    protected void notifyDirectUpdate() {
    }

    @Override
    public int indexOf(String s2, int fromIdx) {
        int strLen = s2.length();
        if (strLen == 0) {
            return fromIdx;
        }
        int absFromIdx = fromIdx + this.start;
        if (strLen > this.end - absFromIdx) {
            return -1;
        }
        int strOffs = 0;
        int lastOffs = this.end - strLen;
        while (absFromIdx <= lastOffs + strOffs) {
            byte b2 = this.buff[absFromIdx];
            if (b2 == s2.charAt(strOffs)) {
                if (++strOffs == strLen) {
                    return absFromIdx - strLen - this.start + 1;
                }
            } else {
                strOffs = 0;
            }
            ++absFromIdx;
        }
        return -1;
    }

    @Override
    public void delete(int start, int end) {
        this.resetStringCache();
        int absDeleteStart = this.start + start;
        int absDeleteEnd = this.start + end;
        int diff = this.end - absDeleteEnd;
        if (diff == 0) {
            this.end = absDeleteStart;
        } else {
            System.arraycopy(this.buff, absDeleteEnd, this.buff, absDeleteStart, diff);
            this.end = absDeleteStart + diff;
        }
    }

    public void append(char c2) throws IOException {
        this.append((byte)c2);
    }

    public void append(byte b2) throws IOException {
        this.resetStringCache();
        this.makeSpace(1);
        if (this.limit > 0 && this.end >= this.limit) {
            this.flushBuffer();
        }
        this.buff[this.end++] = b2;
    }

    public void append(ByteChunk src) throws IOException {
        this.append(src.getBytes(), src.getStart(), src.getLength());
    }

    public void append(byte[] src, int off, int len) throws IOException {
        int remain;
        this.resetStringCache();
        this.makeSpace(len);
        if (this.limit < 0) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (this.optimizedWrite && len == this.limit && this.end == this.start) {
            this.out.realWriteBytes(src, off, len);
            return;
        }
        if (len <= this.limit - this.end) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        int avail = this.limit - this.end;
        System.arraycopy(src, off, this.buff, this.end, avail);
        this.end += avail;
        this.flushBuffer();
        for (remain = len - avail; remain > this.limit - this.end; remain -= this.limit - this.end) {
            this.out.realWriteBytes(src, off + len - remain, this.limit - this.end);
        }
        System.arraycopy(src, off + len - remain, this.buff, this.end, remain);
        this.end += remain;
    }

    public int substract() throws IOException {
        this.resetStringCache();
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n2 = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n2 < 0) {
                return -1;
            }
        }
        return this.buff[this.start++] & 0xFF;
    }

    public int substract(ByteChunk src) throws IOException {
        this.resetStringCache();
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n2 = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n2 < 0) {
                return -1;
            }
        }
        int len = this.getLength();
        src.append(this.buff, this.start, len);
        this.start = this.end;
        return len;
    }

    public int substract(byte[] src, int off, int len) throws IOException {
        int n2;
        this.resetStringCache();
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            n2 = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n2 < 0) {
                return -1;
            }
        }
        n2 = len;
        if (len > this.getLength()) {
            n2 = this.getLength();
        }
        System.arraycopy(this.buff, this.start, src, off, n2);
        this.start += n2;
        return n2;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.limit + ' ' + this.buff.length);
        }
        this.out.realWriteBytes(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    boolean canGrow() {
        if (this.buff.length == this.limit) {
            return false;
        }
        int desiredSize = this.buff.length * 2;
        if (this.limit > 0 && desiredSize > this.limit && this.limit > this.end - this.start) {
            desiredSize = this.limit;
        }
        byte[] tmp = new byte[desiredSize];
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = 0;
        return true;
    }

    private void makeSpace(int count) {
        byte[] tmp;
        int desiredSize = this.end + count;
        if (this.limit > 0 && desiredSize > this.limit) {
            desiredSize = this.limit;
        }
        if (this.buff == null) {
            if (desiredSize < 256) {
                desiredSize = 256;
            }
            this.buff = new byte[desiredSize];
        }
        if (desiredSize <= this.buff.length) {
            return;
        }
        if (desiredSize < 2 * this.buff.length) {
            int newSize = this.buff.length * 2;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        } else {
            int newSize = this.buff.length * 2 + count;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        }
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = 0;
    }

    public void trimLeft() {
        boolean modified = false;
        while (this.buff[this.start] <= 32) {
            modified = true;
            ++this.start;
        }
        if (modified) {
            this.resetStringCache();
        }
    }

    public String toString() {
        if (null == this.buff || this.end - this.start == 0) {
            return "";
        }
        if (this.cachedString != null) {
            return this.cachedString;
        }
        this.cachedString = this.toStringInternal();
        return this.cachedString;
    }

    @Override
    public String toString(int start, int end) {
        if (start == this.start && end == this.end) {
            return this.toString();
        }
        if (null == this.buff) {
            return null;
        }
        if (end - start == 0) {
            return "";
        }
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        try {
            return new String(this.buff, this.start + start, end - start, this.charset.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException("Unexpected error", e2);
        }
    }

    public String toString(Charset charset) {
        if (charset == null) {
            Charset charset2 = charset = this.charset != null ? this.charset : DEFAULT_CHARSET;
        }
        if (this.cachedString != null && charset.equals(this.cachedStringCharset)) {
            return this.cachedString;
        }
        this.cachedString = charset.decode(ByteBuffer.wrap(this.buff, this.start, this.end - this.start)).toString();
        this.cachedStringCharset = charset;
        return this.cachedString;
    }

    public String toStringInternal() {
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        return this.toString(this.charset);
    }

    public int getInt() {
        return Ascii.parseInt(this.buff, this.start, this.end - this.start);
    }

    public long getLong() {
        return Ascii.parseLong(this.buff, this.start, this.end - this.start);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.buff);
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.charset.hashCode();
        result = 31 * result + (this.isSet ? 1 : 0);
        result = 31 * result + this.limit;
        result = 31 * result + this.in.hashCode();
        result = 31 * result + this.out.hashCode();
        result = 31 * result + (this.optimizedWrite ? 1 : 0);
        return result;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ByteChunk byteChunk = (ByteChunk)o2;
        if (this.end != byteChunk.end) {
            return false;
        }
        if (this.isSet != byteChunk.isSet) {
            return false;
        }
        if (this.limit != byteChunk.limit) {
            return false;
        }
        if (this.optimizedWrite != byteChunk.optimizedWrite) {
            return false;
        }
        if (this.start != byteChunk.start) {
            return false;
        }
        if (!Arrays.equals(this.buff, byteChunk.buff)) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(byteChunk.charset) : byteChunk.charset != null) {
            return false;
        }
        if (this.in != null ? !this.in.equals(byteChunk.in) : byteChunk.in != null) {
            return false;
        }
        return !(this.out != null ? !this.out.equals(byteChunk.out) : byteChunk.out != null);
    }

    public boolean equals(String s2) {
        return ByteChunk.equals(this.buff, this.start, this.end - this.start, s2);
    }

    public final boolean equals(byte[] bytes) {
        return ByteChunk.equals(this.buff, this.start, this.end - this.start, bytes, 0, bytes.length);
    }

    public boolean equalsIgnoreCase(String s2) {
        return ByteChunk.equalsIgnoreCase(this.buff, this.start, this.getLength(), s2);
    }

    public boolean equalsIgnoreCase(byte[] b2) {
        return this.equalsIgnoreCase(b2, 0, b2.length);
    }

    public boolean equalsIgnoreCase(byte[] b2, int offset, int len) {
        return ByteChunk.equalsIgnoreCase(this.buff, this.start, this.getLength(), b2, offset, len);
    }

    public boolean equalsIgnoreCaseLowerCase(byte[] cmpTo) {
        return ByteChunk.equalsIgnoreCaseLowerCase(this.buff, this.start, this.end, cmpTo);
    }

    public boolean equals(ByteChunk bb2) {
        return this.equals(bb2.getBytes(), bb2.getStart(), bb2.getLength());
    }

    public boolean equals(byte[] b2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (len2 != len || b1 == null || b2 == null) {
            return false;
        }
        int off1 = this.start;
        while (len-- > 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk cc2) {
        return this.equals(cc2.getChars(), cc2.getStart(), cc2.getLength());
    }

    public boolean equals(char[] c2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (c2 == null && b1 == null) {
            return true;
        }
        if (b1 == null || c2 == null || this.end - this.start != len2) {
            return false;
        }
        int off1 = this.start;
        int len = this.end - this.start;
        while (len-- > 0) {
            if ((char)b1[off1++] == c2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s2) {
        return this.startsWith(s2, 0);
    }

    public boolean startsWith(String s2, int offset) {
        byte[] b2 = this.buff;
        int len = s2.length();
        if (b2 == null || len + offset > this.end - this.start) {
            return false;
        }
        int off = this.start + offset;
        for (int i2 = 0; i2 < len; ++i2) {
            if (b2[off++] == s2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(byte[] b2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (b1 == null || b2 == null || b2.length > len) {
            return false;
        }
        int i2 = this.start;
        int j2 = 0;
        while (i2 < this.end && j2 < b2.length) {
            if (b1[i2++] == b2[j2++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s2, int pos) {
        byte[] b2 = this.buff;
        int len = s2.length();
        if (b2 == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        for (int i2 = 0; i2 < len; ++i2) {
            if (Ascii.toLower(b2[off++]) == Ascii.toLower(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String src, int srcOff, int srcLen, int myOff) {
        char first = src.charAt(srcOff);
        int srcEnd = srcOff + srcLen;
        for (int i2 = myOff + this.start; i2 <= this.end - srcLen; ++i2) {
            if (this.buff[i2] != first) continue;
            int myPos = i2 + 1;
            int srcPos = srcOff + 1;
            while (srcPos < srcEnd && this.buff[myPos++] == src.charAt(srcPos++)) {
                if (srcPos != srcEnd) continue;
                return i2 - this.start;
            }
        }
        return -1;
    }

    public int hash() {
        return ByteChunk.hashBytes(this.buff, this.start, this.end - this.start);
    }

    public int hashIgnoreCase() {
        return ByteChunk.hashBytesIC(this.buff, this.start, this.end - this.start);
    }

    public static boolean equals(byte[] b1, int b1Offs, int b1Len, byte[] b2, int b2Offs, int b2Len) {
        if (b1Len != b2Len) {
            return false;
        }
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < b1Len; ++i2) {
            if (b1[i2 + b1Offs] == b2[i2 + b2Offs]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] b2, int offs, int len, String s2) {
        if (b2 == null || len != s2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (b2[offs++] == s2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(byte[] b1, int b1Offs, int b1Len, byte[] b2, int b2Offs, int b2Len) {
        if (b1Len != b2Len) {
            return false;
        }
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < b1Len; ++i2) {
            if (Ascii.toLower(b1[i2 + b1Offs]) == Ascii.toLower(b2[i2 + b2Offs])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(byte[] b2, int offset, int len, String s2) {
        if (len != s2.length()) {
            return false;
        }
        int boff = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            if (Ascii.toLower(b2[boff++]) == Ascii.toLower(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseLowerCase(byte[] buffer, int start, int end, byte[] cmpTo) {
        int len = end - start;
        if (len != cmpTo.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (Ascii.toLower(buffer[i2 + start]) == cmpTo[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] buffer, int start, int end, byte[] cmpTo) {
        int len = end - start;
        if (len < cmpTo.length) {
            return false;
        }
        for (int i2 = 0; i2 < cmpTo.length; ++i2) {
            if (buffer[start + i2] == cmpTo[i2]) continue;
            return false;
        }
        return true;
    }

    private static int hashBytes(byte[] buff, int start, int bytesLen) {
        int max = start + bytesLen;
        int code = 0;
        for (int i2 = start; i2 < max; ++i2) {
            code = code * 31 + buff[i2];
        }
        return code;
    }

    private static int hashBytesIC(byte[] bytes, int start, int bytesLen) {
        int max = start + bytesLen;
        int code = 0;
        for (int i2 = start; i2 < max; ++i2) {
            code = code * 31 + Ascii.toLower(bytes[i2]);
        }
        return code;
    }

    @Override
    public int indexOf(char c2, int starting) {
        int ret = ByteChunk.indexOf(this.buff, this.start + starting, this.end, c2);
        return ret >= this.start ? ret - this.start : -1;
    }

    public static int indexOf(byte[] bytes, int off, int end, char qq) {
        while (off < end) {
            byte b2 = bytes[off];
            if (b2 == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int findChar(byte[] buf, int start, int end, char c2) {
        byte b2 = (byte)c2;
        for (int offset = start; offset < end; ++offset) {
            if (buf[offset] != b2) continue;
            return offset;
        }
        return -1;
    }

    public static int findChars(byte[] buf, int start, int end, byte[] c2) {
        int clen = c2.length;
        for (int offset = start; offset < end; ++offset) {
            for (int i2 = 0; i2 < clen; ++i2) {
                if (buf[offset] != c2[i2]) continue;
                return offset;
            }
        }
        return -1;
    }

    public static int findNotChars(byte[] buf, int start, int end, byte[] c2) {
        int clen = c2.length;
        for (int offset = start; offset < end; ++offset) {
            boolean found = true;
            for (int i2 = 0; i2 < clen; ++i2) {
                if (buf[offset] != c2[i2]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return offset;
        }
        return -1;
    }

    public static byte[] convertToBytes(String value) {
        byte[] result = new byte[value.length()];
        for (int i2 = 0; i2 < value.length(); ++i2) {
            result[i2] = (byte)value.charAt(i2);
        }
        return result;
    }

    public static interface ByteOutputChannel {
        public void realWriteBytes(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ByteInputChannel {
        public int realReadBytes(byte[] var1, int var2, int var3) throws IOException;
    }
}

