/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.B2CConverterBlocking;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.grizzly.utils.Charsets;

public class B2CConverter {
    private static final boolean IS_OLD_IO_MODE = Boolean.getBoolean(B2CConverter.class.getName() + ".blockingMode");
    private static final Logger logger = Grizzly.logger(B2CConverter.class);
    private static final int MAX_NUMBER_OF_BYTES_PER_CHARACTER = 16;
    private CharsetDecoder decoder;
    private final ByteBuffer remainder = ByteBuffer.allocate(16);
    private B2CConverterBlocking blockingConverter;

    protected B2CConverter() {
        this.init("US-ASCII");
    }

    public B2CConverter(String encoding) throws IOException {
        this.init(encoding);
    }

    protected void init(String encoding) {
        if (IS_OLD_IO_MODE) {
            try {
                this.blockingConverter = new B2CConverterBlocking(encoding);
            }
            catch (IOException e2) {
                throw new IllegalStateException("Can not initialize blocking converter");
            }
        } else {
            Charset charset = Charsets.lookupCharset(encoding);
            this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    }

    public void recycle() {
        if (IS_OLD_IO_MODE) {
            this.blockingConverter.recycle();
        }
    }

    public void convert(ByteChunk bb2, CharChunk cb2) throws IOException {
        this.convert(bb2, cb2, cb2.getBuffer().length - cb2.getEnd());
    }

    public void convert(ByteChunk bb2, CharChunk cb2, int limit) throws IOException {
        if (IS_OLD_IO_MODE) {
            this.blockingConverter.convert(bb2, cb2, limit);
            return;
        }
        try {
            int bbAvailable = bb2.getEnd() - bb2.getStart();
            if (limit > bbAvailable) {
                limit = bbAvailable;
            }
            byte[] barr = bb2.getBuffer();
            int boff = bb2.getStart();
            ByteBuffer tmp_bb = ByteBuffer.wrap(barr, boff, limit);
            char[] carr = cb2.getBuffer();
            int coff = cb2.getEnd();
            int remain = carr.length - coff;
            int cbLimit = cb2.getLimit();
            if (remain < limit && (cbLimit < 0 || cbLimit > carr.length)) {
                cb2.makeSpace(limit);
                carr = cb2.getBuffer();
                coff = cb2.getEnd();
            }
            CharBuffer tmp_cb = CharBuffer.wrap(carr, coff, carr.length - coff);
            if (this.remainder.position() > 0) {
                this.flushRemainder(tmp_bb, tmp_cb);
            }
            CoderResult cr2 = this.decoder.decode(tmp_bb, tmp_cb, false);
            cb2.setEnd(tmp_cb.position());
            while (cr2 == CoderResult.OVERFLOW) {
                cb2.flushBuffer();
                coff = cb2.getEnd();
                carr = cb2.getBuffer();
                tmp_cb = CharBuffer.wrap(carr, coff, carr.length - coff);
                cr2 = this.decoder.decode(tmp_bb, tmp_cb, false);
                cb2.setEnd(tmp_cb.position());
            }
            bb2.setStart(tmp_bb.position());
            if (tmp_bb.hasRemaining()) {
                this.remainder.put(tmp_bb);
            }
            if (cr2 != CoderResult.UNDERFLOW) {
                throw new IOException("Encoding error");
            }
        }
        catch (IOException ex2) {
            int debug = 0;
            if (debug > 0) {
                this.log("B2CConverter " + ex2.toString());
            }
            this.decoder.reset();
            throw ex2;
        }
    }

    public static void convertASCII(MessageBytes mb) {
        if (IS_OLD_IO_MODE) {
            B2CConverterBlocking.convertASCII(mb);
            return;
        }
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc2 = mb.getByteChunk();
        CharChunk cc2 = mb.getCharChunk();
        int length = bc2.getLength();
        cc2.allocate(length, -1);
        byte[] bbuf = bc2.getBuffer();
        char[] cbuf = cc2.getBuffer();
        int start = bc2.getStart();
        for (int i2 = 0; i2 < length; ++i2) {
            cbuf[i2] = (char)(bbuf[i2 + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, length);
    }

    public void reset() throws IOException {
        if (IS_OLD_IO_MODE) {
            this.blockingConverter.reset();
            return;
        }
        if (this.decoder != null) {
            this.decoder.reset();
            this.remainder.clear();
        }
    }

    void log(String s2) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "B2CConverter: " + s2);
        }
    }

    private void flushRemainder(ByteBuffer tmp_bb, CharBuffer tmp_cb) {
        while (this.remainder.position() > 0 && tmp_bb.hasRemaining()) {
            this.remainder.put(tmp_bb.get());
            this.remainder.flip();
            CoderResult cr2 = this.decoder.decode(this.remainder, tmp_cb, false);
            if (cr2 == CoderResult.OVERFLOW) {
                throw new IllegalStateException("CharChunk is not big enough");
            }
            if (!this.remainder.hasRemaining()) {
                this.remainder.clear();
                break;
            }
            this.remainder.compact();
        }
    }
}

