/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.v4.runtime.misc.IntegerList;
import org.antlr.v4.runtime.misc.IntervalSet;

public class Utils {
    public static <T> String join(Iterator<T> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static <T> String join(T[] array, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < array.length; ++i2) {
            builder.append(array[i2]);
            if (i2 >= array.length - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static int numNonnull(Object[] data) {
        int n2 = 0;
        if (data == null) {
            return n2;
        }
        for (Object o2 : data) {
            if (o2 == null) continue;
            ++n2;
        }
        return n2;
    }

    public static <T> void removeAllElements(Collection<T> data, T value) {
        if (data == null) {
            return;
        }
        while (data.contains(value)) {
            data.remove(value);
        }
    }

    public static String escapeWhitespace(String s2, boolean escapeSpaces) {
        StringBuilder buf = new StringBuilder();
        for (char c2 : s2.toCharArray()) {
            if (c2 == ' ' && escapeSpaces) {
                buf.append('\u00b7');
                continue;
            }
            if (c2 == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c2 == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    public static void writeFile(String fileName, String content) throws IOException {
        Utils.writeFile(fileName, content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String content, String encoding) throws IOException {
        File f2 = new File(fileName);
        FileOutputStream fos = new FileOutputStream(f2);
        try (OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter(fos);){
            osw.write(content);
        }
    }

    public static char[] readFile(String fileName) throws IOException {
        return Utils.readFile(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readFile(String fileName, String encoding) throws IOException {
        File f2 = new File(fileName);
        int size = (int)f2.length();
        FileInputStream fis = new FileInputStream(fileName);
        char[] data = null;
        try (InputStreamReader isr = encoding != null ? new InputStreamReader((InputStream)fis, encoding) : new InputStreamReader(fis);){
            data = new char[size];
            int n2 = isr.read(data);
            if (n2 < data.length) {
                data = Arrays.copyOf(data, n2);
            }
        }
        return data;
    }

    public static Map<String, Integer> toMap(String[] keys2) {
        HashMap<String, Integer> m3 = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < keys2.length; ++i2) {
            m3.put(keys2[i2], i2);
        }
        return m3;
    }

    public static char[] toCharArray(IntegerList data) {
        if (data == null) {
            return null;
        }
        return data.toCharArray();
    }

    public static IntervalSet toSet(BitSet bits) {
        IntervalSet s2 = new IntervalSet(new int[0]);
        int i2 = bits.nextSetBit(0);
        while (i2 >= 0) {
            s2.add(i2);
            i2 = bits.nextSetBit(i2 + 1);
        }
        return s2;
    }

    public static String expandTabs(String s2, int tabSize) {
        if (s2 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int col = 0;
        block4: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '\n': {
                    col = 0;
                    buf.append(c2);
                    continue block4;
                }
                case '\t': {
                    int n2 = tabSize - col % tabSize;
                    col += n2;
                    buf.append(Utils.spaces(n2));
                    continue block4;
                }
                default: {
                    ++col;
                    buf.append(c2);
                }
            }
        }
        return buf.toString();
    }

    public static String spaces(int n2) {
        return Utils.sequence(n2, " ");
    }

    public static String newlines(int n2) {
        return Utils.sequence(n2, "\n");
    }

    public static String sequence(int n2, String s2) {
        StringBuilder buf = new StringBuilder();
        for (int sp = 1; sp <= n2; ++sp) {
            buf.append(s2);
        }
        return buf.toString();
    }

    public static int count(String s2, char x2) {
        int n2 = 0;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (s2.charAt(i2) != x2) continue;
            ++n2;
        }
        return n2;
    }
}

