/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.convert;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;

public class ConvertCommand
extends AbstractCommand {
    private String src;
    private String out;
    private String classpath;

    @Override
    public String getName() {
        return "convert";
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getOut() {
        return this.out;
    }

    public void setOut(String out) {
        this.out = out;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    protected CommandResult run() throws Exception {
        ArrayList<ResourceAccessor> openers = new ArrayList<ResourceAccessor>();
        openers.add(new FileSystemResourceAccessor(new File[0]));
        openers.add(new ClassLoaderResourceAccessor());
        if (this.classpath != null) {
            openers.add(new FileSystemResourceAccessor(new File(this.classpath)));
        }
        CompositeResourceAccessor resourceAccessor = new CompositeResourceAccessor(openers);
        ChangeLogParser sourceParser = ChangeLogParserFactory.getInstance().getParser(this.src, resourceAccessor);
        ChangeLogSerializer outSerializer = ChangeLogSerializerFactory.getInstance().getSerializer(this.out);
        DatabaseChangeLog changeLog = sourceParser.parse(this.src, new ChangeLogParameters(), resourceAccessor);
        File outFile = new File(this.out);
        if (!outFile.exists()) {
            outFile.getParentFile().mkdirs();
        }
        try (FileOutputStream outputStream2 = new FileOutputStream(outFile);){
            outSerializer.write(changeLog.getChangeSets(), outputStream2);
        }
        return new CommandResult("Converted successfully");
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }
}

