/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub;

import java.util.List;
import java.util.UUID;
import liquibase.changelog.RanChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.HubRegisterResponse;
import liquibase.hub.model.HubUser;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChange;
import liquibase.hub.model.OperationChangeEvent;
import liquibase.hub.model.OperationEvent;
import liquibase.hub.model.Organization;
import liquibase.hub.model.Project;
import liquibase.plugin.AbstractPluginFactory;

public class HubServiceFactory
extends AbstractPluginFactory<HubService> {
    private String offlineReason;
    private static final FallbackHubService fallbackHubService = new FallbackHubService();

    protected HubServiceFactory() {
    }

    @Override
    protected Class<HubService> getPluginClass() {
        return HubService.class;
    }

    @Override
    protected int getPriority(HubService obj, Object ... args2) {
        return obj.getPriority();
    }

    public HubService getService() {
        HubService plugin = (HubService)this.getPlugin(new Object[0]);
        if (plugin == null) {
            return fallbackHubService;
        }
        return plugin;
    }

    public boolean isOnline() {
        return this.getService().isOnline();
    }

    public String getOfflineReason() {
        return this.offlineReason;
    }

    public void setOfflineReason(String offlineReason) {
        this.offlineReason = offlineReason;
    }

    private static class FallbackHubService
    implements HubService {
        private FallbackHubService() {
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public boolean isOnline() {
            return false;
        }

        @Override
        public HubUser getMe() throws LiquibaseHubException {
            return null;
        }

        @Override
        public HubChangeLog deactivateChangeLog(HubChangeLog hubChangeLog) throws LiquibaseHubException {
            return null;
        }

        @Override
        public HubChangeLog getHubChangeLog(UUID changeLogId, String includeStatus) throws LiquibaseHubException {
            return null;
        }

        @Override
        public Organization getOrganization() throws LiquibaseHubException {
            return null;
        }

        @Override
        public Project getProject(UUID projectId) throws LiquibaseHubException {
            return null;
        }

        @Override
        public List<Project> getProjects() throws LiquibaseHubException {
            return null;
        }

        @Override
        public Project createProject(Project project) throws LiquibaseException {
            return null;
        }

        @Override
        public void setRanChangeSets(Connection connectionId, List<RanChangeSet> ranChangeSets) throws LiquibaseHubException {
        }

        @Override
        public HubChangeLog getHubChangeLog(UUID changeLogId) throws LiquibaseHubException {
            return null;
        }

        @Override
        public List<Connection> getConnections(Connection exampleConnection) throws LiquibaseHubException {
            return null;
        }

        @Override
        public Connection getConnection(Connection exampleConnection, boolean createIfNotExists) throws LiquibaseHubException {
            return null;
        }

        @Override
        public HubRegisterResponse register(String email) throws LiquibaseException {
            return null;
        }

        @Override
        public Connection createConnection(Connection connection) throws LiquibaseHubException {
            return null;
        }

        @Override
        public HubChangeLog createChangeLog(HubChangeLog hubChangeLog) throws LiquibaseException {
            return null;
        }

        @Override
        public Operation createOperation(String operationType, HubChangeLog changeLog, Connection connection) throws LiquibaseHubException {
            return null;
        }

        @Override
        public OperationEvent sendOperationEvent(Operation operation, OperationEvent operationEvent) throws LiquibaseException {
            return null;
        }

        @Override
        public String shortenLink(String url) throws LiquibaseException {
            return null;
        }

        @Override
        public void sendOperationChangeEvent(OperationChangeEvent operationChangeEvent) throws LiquibaseException {
        }

        @Override
        public void sendOperationChanges(OperationChange operationChange) throws LiquibaseHubException {
        }
    }
}

