/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.ChangelogRewriter;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Project;
import liquibase.ui.UIService;
import liquibase.util.StringUtil;

public class RegisterChangeLogCommand
extends AbstractSelfConfiguratingCommand<CommandResult> {
    private PrintStream outputStream = System.out;
    private HubChangeLog hubChangeLog;
    private String changeLogFile;
    private Map<String, Object> argsMap = new HashMap<String, Object>();
    private UUID hubProjectId;
    private String hubProjectName;

    public HubChangeLog getHubChangeLog() {
        return this.hubChangeLog;
    }

    public void setProjectName(String hubProjectName) {
        this.hubProjectName = hubProjectName;
    }

    public void setHubProjectId(UUID hubProjectId) {
        this.hubProjectId = hubProjectId;
    }

    @Override
    public void configure(Map<String, Object> argsMap) throws LiquibaseException {
        this.argsMap = argsMap;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    @Override
    public String getName() {
        return "registerChangeLog";
    }

    @Override
    public CommandValidationErrors validate() {
        return null;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream2) {
        this.outputStream = outputStream2;
    }

    @Override
    protected CommandResult run() throws Exception {
        Project project;
        String changeLogId;
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (!hubServiceFactory.isOnline()) {
            return new CommandResult("The command registerChangeLog requires access to Liquibase Hub: " + hubServiceFactory.getOfflineReason() + ".  Learn more at https://hub.liquibase.com", false);
        }
        HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)this.argsMap.get("changeLog");
        String string = changeLogId = databaseChangeLog != null ? databaseChangeLog.getChangeLogId() : null;
        if (changeLogId != null) {
            this.hubChangeLog = service.getHubChangeLog(UUID.fromString(changeLogId));
            if (this.hubChangeLog != null) {
                return new CommandResult("Changelog '" + this.changeLogFile + "' is already registered with changeLogId '" + changeLogId + "' to project '" + this.hubChangeLog.getProject().getName() + "' with project ID '" + this.hubChangeLog.getProject().getId().toString() + "'.\nFor more information visit https://docs.liquibase.com.", false);
            }
            return new CommandResult("Changelog '" + this.changeLogFile + "' is already registered with changeLogId '" + changeLogId + "'.\nFor more information visit https://docs.liquibase.com.", false);
        }
        if (this.hubProjectId != null) {
            project = service.getProject(this.hubProjectId);
            if (project == null) {
                return new CommandResult("Project Id '" + this.hubProjectId + "' does not exist or you do not have access to it", false);
            }
        } else if (this.hubProjectName != null) {
            if (this.hubProjectName.length() > 255) {
                return new CommandResult("\nThe project name you gave is longer than 255 characters\n\n");
            }
            project = service.createProject(new Project().setName(this.hubProjectName));
            if (project == null) {
                return new CommandResult("Unable to create project '" + this.hubProjectName + "'.\nLearn more at https://hub.liquibase.com.", false);
            }
            this.outputStream.print("\nProject '" + project.getName() + "' created with project ID '" + project.getId() + "'.\n\n");
        } else {
            project = this.retrieveOrCreateProject(service);
            if (project == null) {
                return new CommandResult("Your changelog " + this.changeLogFile + " was not registered to any Liquibase Hub project. You can still run Liquibase commands, but no data will be saved in your Liquibase Hub account for monitoring or reports.  Learn more at https://hub.liquibase.com.", false);
            }
        }
        HubChangeLog newChangeLog = new HubChangeLog();
        newChangeLog.setProject(project);
        newChangeLog.setFileName(databaseChangeLog.getFilePath());
        newChangeLog.setName(databaseChangeLog.getFilePath());
        this.hubChangeLog = service.createChangeLog(newChangeLog);
        ChangelogRewriter.ChangeLogRewriterResult changeLogRewriterResult = ChangelogRewriter.addChangeLogId(this.changeLogFile, this.hubChangeLog.getId().toString(), databaseChangeLog);
        Scope.getCurrentScope().getLog(RegisterChangeLogCommand.class).info(changeLogRewriterResult.message);
        String message = "* Changelog file '" + this.changeLogFile + "' with changelog ID '" + this.hubChangeLog.getId().toString() + "' has been registered";
        return new CommandResult(message, changeLogRewriterResult.success);
    }

    private Project retrieveOrCreateProject(HubService service) throws CommandLineParsingException, LiquibaseException, LiquibaseHubException {
        Project project = null;
        List<Project> projects = this.getProjectsFromHub();
        boolean done = false;
        String input = null;
        while (!done) {
            input = this.readProjectFromConsole(projects);
            try {
                if (input.equalsIgnoreCase("C")) {
                    String projectName = this.readProjectNameFromConsole();
                    if (StringUtil.isEmpty(projectName)) {
                        this.outputStream.print("\nNo project created\n\n");
                        continue;
                    }
                    if (projectName.length() > 255) {
                        this.outputStream.print("\nThe project name you entered is longer than 255 characters\n\n");
                        continue;
                    }
                    project = service.createProject(new Project().setName(projectName));
                    if (project == null) {
                        String message = "Unable to create project '" + projectName + "'";
                        Scope.getCurrentScope().getUI().sendMessage(message);
                        Scope.getCurrentScope().getLog(RegisterChangeLogCommand.class).warning(message);
                        return null;
                    }
                    this.outputStream.print("\nProject '" + project.getName() + "' created with project ID '" + project.getId() + "'.\n\n");
                    projects = this.getProjectsFromHub();
                    done = true;
                    continue;
                }
                if (input.equalsIgnoreCase("N")) {
                    return null;
                }
                int projectIdx = Integer.parseInt(input);
                if (projectIdx > 0 && projectIdx <= projects.size()) {
                    project = projects.get(projectIdx - 1);
                    if (project == null) continue;
                    done = true;
                    continue;
                }
                this.outputStream.printf("\nInvalid project '%d' selected\n\n", projectIdx);
            }
            catch (NumberFormatException nfe) {
                this.outputStream.printf("\nInvalid selection '" + input + "'\n\n", new Object[0]);
            }
        }
        return project;
    }

    private List<Project> getProjectsFromHub() throws LiquibaseHubException {
        HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        List<Project> projects = service.getProjects();
        Collections.sort(projects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                Date date1 = o1.getCreateDate();
                Date date2 = o2.getCreateDate();
                return date2.compareTo(date1);
            }
        });
        return projects;
    }

    private String readProjectNameFromConsole() throws CommandLineParsingException {
        UIService ui = Scope.getCurrentScope().getUI();
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        String hubUrl = hubConfiguration.getLiquibaseHubUrl();
        String input = ui.prompt("Please enter your Project name and press [enter].  This is editable in your Liquibase Hub account at " + hubUrl, null, null, String.class);
        return StringUtil.trimToEmpty(input);
    }

    private String readProjectFromConsole(List<Project> projects) throws CommandLineParsingException {
        UIService ui = Scope.getCurrentScope().getUI();
        StringBuilder prompt = new StringBuilder("Registering a changelog connects Liquibase operations to a Project for monitoring and reporting.\n");
        prompt.append("Register changelog " + this.changeLogFile + " to an existing Project, or create a new one.\n");
        prompt.append("Please make a selection:\n");
        prompt.append("[c] Create new Project\n");
        String projFormat = "[%d]";
        if (projects.size() >= 10 && projects.size() < 100) {
            projFormat = "[%2d]";
        } else if (projects.size() >= 100 && projects.size() < 1000) {
            projFormat = "[%3d]";
        } else if (projects.size() >= 1000 && projects.size() < 10000) {
            projFormat = "[%4d]";
        }
        int maxLen = 40;
        for (Project project : projects) {
            if (project.getName() == null || project.getName().length() <= maxLen) continue;
            maxLen = project.getName().length();
        }
        for (int i2 = 0; i2 < projects.size(); ++i2) {
            Project project;
            project = projects.get(i2);
            prompt.append(String.format(projFormat + " %-" + maxLen + "s (Project ID:%s) %s\n", i2 + 1, project.getName(), projects.get(i2).getId(), projects.get(i2).getCreateDate()));
        }
        prompt.append("[N] to not register this changelog right now.\nYou can still run Liquibase commands, but no data will be saved in your Liquibase Hub account for monitoring or reports.\n Learn more at https://hub.liquibase.com.\n?");
        return StringUtil.trimToEmpty(ui.prompt(prompt.toString(), "N", null, String.class));
    }
}

