/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private volatile Vector<TransportListener> transportListeners = null;

    public Transport(Session session, URLName urlname) {
        super(session, urlname);
    }

    public static void send(Message msg) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, msg.getAllRecipients(), null, null);
    }

    public static void send(Message msg, Address[] addresses) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, addresses, null, null);
    }

    public static void send(Message msg, String user, String password) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, msg.getAllRecipients(), user, password);
    }

    public static void send(Message msg, Address[] addresses, String user, String password) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, addresses, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send0(Message msg, Address[] addresses, String user, String password) throws MessagingException {
        Session s2;
        if (addresses == null || addresses.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        HashMap protocols = new HashMap();
        ArrayList<Address> invalid = new ArrayList<Address>();
        ArrayList<Address> validSent = new ArrayList<Address>();
        ArrayList<Address> validUnsent = new ArrayList<Address>();
        for (int i2 = 0; i2 < addresses.length; ++i2) {
            if (protocols.containsKey(addresses[i2].getType())) {
                List v2 = (List)protocols.get(addresses[i2].getType());
                v2.add(addresses[i2]);
                continue;
            }
            ArrayList<Address> w2 = new ArrayList<Address>();
            w2.add(addresses[i2]);
            protocols.put(addresses[i2].getType(), w2);
        }
        int dsize = protocols.size();
        if (dsize == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Session session = s2 = msg.session != null ? msg.session : Session.getDefaultInstance(System.getProperties(), null);
        if (dsize == 1) {
            try (Transport transport = s2.getTransport(addresses[0]);){
                if (user != null) {
                    transport.connect(user, password);
                } else {
                    transport.connect();
                }
                transport.sendMessage(msg, addresses);
            }
            return;
        }
        MessagingException chainedEx = null;
        boolean sendFailed = false;
        for (List v3 : protocols.values()) {
            Address[] protaddresses = new Address[v3.size()];
            v3.toArray(protaddresses);
            Transport transport = s2.getTransport(protaddresses[0]);
            if (transport == null) {
                for (int j2 = 0; j2 < protaddresses.length; ++j2) {
                    invalid.add(protaddresses[j2]);
                }
                continue;
            }
            try {
                transport.connect();
                transport.sendMessage(msg, protaddresses);
            }
            catch (SendFailedException sex) {
                Address[] c2;
                sendFailed = true;
                if (chainedEx == null) {
                    chainedEx = sex;
                } else {
                    chainedEx.setNextException(sex);
                }
                Address[] a2 = sex.getInvalidAddresses();
                if (a2 != null) {
                    for (int j3 = 0; j3 < a2.length; ++j3) {
                        invalid.add(a2[j3]);
                    }
                }
                if ((a2 = sex.getValidSentAddresses()) != null) {
                    for (int k2 = 0; k2 < a2.length; ++k2) {
                        validSent.add(a2[k2]);
                    }
                }
                if ((c2 = sex.getValidUnsentAddresses()) == null) continue;
                for (int l2 = 0; l2 < c2.length; ++l2) {
                    validUnsent.add(c2[l2]);
                }
            }
            catch (MessagingException mex) {
                sendFailed = true;
                if (chainedEx == null) {
                    chainedEx = mex;
                    continue;
                }
                chainedEx.setNextException(mex);
            }
            finally {
                transport.close();
            }
        }
        if (sendFailed || invalid.size() != 0 || validUnsent.size() != 0) {
            Address[] a3 = null;
            Address[] b2 = null;
            Address[] c3 = null;
            if (validSent.size() > 0) {
                a3 = new Address[validSent.size()];
                validSent.toArray(a3);
            }
            if (validUnsent.size() > 0) {
                b2 = new Address[validUnsent.size()];
                validUnsent.toArray(b2);
            }
            if (invalid.size() > 0) {
                c3 = new Address[invalid.size()];
                invalid.toArray(c3);
            }
            throw new SendFailedException("Sending failed", chainedEx, a3, b2, c3);
        }
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public synchronized void addTransportListener(TransportListener l2) {
        if (this.transportListeners == null) {
            this.transportListeners = new Vector();
        }
        this.transportListeners.addElement(l2);
    }

    public synchronized void removeTransportListener(TransportListener l2) {
        if (this.transportListeners != null) {
            this.transportListeners.removeElement(l2);
        }
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message msg) {
        if (this.transportListeners == null) {
            return;
        }
        TransportEvent e2 = new TransportEvent(this, type, validSent, validUnsent, invalid, msg);
        this.queueEvent(e2, this.transportListeners);
    }
}

