/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.EventListener;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.mail.Session;
import javax.mail.event.MailEvent;

class EventQueue
implements Runnable {
    private volatile BlockingQueue<QueueElement> q;
    private Executor executor;
    private static WeakHashMap<ClassLoader, EventQueue> appq;

    EventQueue(Executor ex2) {
        this.executor = ex2;
    }

    synchronized void enqueue(MailEvent event, Vector<? extends EventListener> vector) {
        if (this.q == null) {
            this.q = new LinkedBlockingQueue<QueueElement>();
            if (this.executor != null) {
                this.executor.execute(this);
            } else {
                Thread qThread = new Thread((Runnable)this, "Jakarta-Mail-EventQueue");
                qThread.setDaemon(true);
                qThread.start();
            }
        }
        this.q.add(new QueueElement(event, vector));
    }

    synchronized void terminateQueue() {
        if (this.q != null) {
            Vector dummyListeners = new Vector();
            dummyListeners.setSize(1);
            this.q.add(new QueueElement(new TerminatorEvent(), dummyListeners));
            this.q = null;
        }
    }

    static synchronized EventQueue getApplicationEventQueue(Executor ex2) {
        EventQueue q2;
        ClassLoader cl2 = Session.getContextClassLoader();
        if (appq == null) {
            appq = new WeakHashMap();
        }
        if ((q2 = appq.get(cl2)) == null) {
            q2 = new EventQueue(ex2);
            appq.put(cl2, q2);
        }
        return q2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        BlockingQueue<QueueElement> bq2 = this.q;
        if (bq2 == null) {
            return;
        }
        try {
            while (true) {
                QueueElement qe = bq2.take();
                MailEvent e2 = qe.event;
                Vector<? extends EventListener> v2 = qe.vector;
                for (int i2 = 0; i2 < v2.size(); ++i2) {
                    try {
                        e2.dispatch(v2.elementAt(i2));
                        continue;
                    }
                    catch (Throwable t2) {
                        if (t2 instanceof InterruptedException) return;
                    }
                }
                qe = null;
                e2 = null;
                v2 = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class QueueElement {
        MailEvent event = null;
        Vector<? extends EventListener> vector = null;

        QueueElement(MailEvent event, Vector<? extends EventListener> vector) {
            this.event = event;
            this.vector = vector;
        }
    }

    static class TerminatorEvent
    extends MailEvent {
        private static final long serialVersionUID = -2481895000841664111L;

        TerminatorEvent() {
            super(new Object());
        }

        @Override
        public void dispatch(Object listener) {
            Thread.currentThread().interrupt();
        }
    }
}

