/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.util;

import com.google.common.collect.Lists;
import horse.wtf.nzyme.dot11.interceptors.CryptoChangeInterceptorSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Dot11CryptoComparator {
    private static final Logger LOG = LogManager.getLogger(CryptoChangeInterceptorSet.class);

    public static boolean compareSecurity(List<String> encountered, List<String> expected) {
        if (expected.size() != encountered.size()) {
            LOG.debug("Unexpected security settings: expected size <{}> does not match encountered size <{}>.", (Object)expected.size(), (Object)encountered.size());
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        ArrayList seen = Lists.newArrayList();
        encountered.forEach(e2 -> {
            if (seen.contains(e2)) {
                LOG.warn("Unexpected security settings: Encountered contains duplicate security [{}]. This is not 802.11 compliant and highly unusual.", e2);
                result.set(false);
            }
        });
        if (!result.get()) {
            return false;
        }
        expected.forEach(e2 -> {
            if (!encountered.contains(e2)) {
                LOG.debug("Unexpected security settings: Expected security [{}] not in encountered [{}].", e2, (Object)encountered);
                result.set(false);
            }
        });
        return result.get();
    }
}

