/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.web;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.rest.RestTools;
import horse.wtf.nzyme.rest.web.AssetManifest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;

public class IndexHtmlGenerator {
    private final String template;
    private final LeaderConfiguration configuration;
    private final Engine templateEngine;
    private final List<String> jsFiles;
    private final List<String> cssFiles;

    public IndexHtmlGenerator(LeaderConfiguration configuration, AssetManifest assetManifest) throws IOException {
        this(Resources.toString(Resources.getResource("web-interface/index.html.template"), StandardCharsets.UTF_8), assetManifest.getJsFiles(), assetManifest.getCssFiles(), Engine.createEngine(), configuration);
    }

    private IndexHtmlGenerator(String template, List<String> jsFiles, List<String> cssFiles, Engine templateEngine, LeaderConfiguration configuration) throws IOException {
        this.template = Objects.requireNonNull(template, "template");
        this.jsFiles = Objects.requireNonNull(jsFiles, "jsFiles");
        this.cssFiles = Objects.requireNonNull(cssFiles, "cssFiles");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public String get(MultivaluedMap<String, String> headers) {
        ImmutableMap<String, Object> model = ImmutableMap.builder().put("title", "nzyme - WiFi Defense System").put("jsFiles", (String)((Object)this.jsFiles)).put("cssFiles", this.cssFiles).put("appPrefix", (List<String>)((Object)RestTools.buildExternalUri(headers, this.configuration.httpExternalUri()))).put("apiUri", (List<String>)((Object)RestTools.buildExternalUri(headers, this.configuration.httpExternalUri()))).build();
        return this.templateEngine.transform(this.template, model);
    }
}

