/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetManifest {
    private final List<String> jsFiles = Lists.newArrayList();
    private final List<String> cssFiles = Lists.newArrayList();

    public AssetManifest() {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        InputStream vendorManifestStream = this.getClass().getResourceAsStream("/web-interface/assets/asset-manifest.json");
        if (vendorManifestStream != null) {
            Map manifest;
            try {
                manifest = om.readValue(vendorManifestStream, new TypeReference<HashMap<String, String>>(){});
            }
            catch (IOException e2) {
                throw new RuntimeException("Unable to read asset manifest.", e2);
            }
            for (String x2 : manifest.values()) {
                if (x2.endsWith(".css")) {
                    this.cssFiles.add(x2.split("/")[2]);
                }
                if (!x2.endsWith(".js")) continue;
                this.jsFiles.add(x2.split("/")[2]);
            }
        } else {
            throw new IllegalStateException("Unable to find vendor assets. Make sure to run `mvn package` at least once locally.");
        }
    }

    public List<String> getJsFiles() {
        return this.jsFiles;
    }

    public List<String> getCssFiles() {
        return this.cssFiles;
    }
}

