/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.tls;

import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    static List<byte[]> readCertificates(Path path) throws CertificateException {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e2) {
            throw new CertificateException("Couldn't read certificates from file: " + path, e2);
        }
        String content = new String(bytes, StandardCharsets.US_ASCII);
        Matcher m3 = CERT_PATTERN.matcher(content);
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        int start = 0;
        while (m3.find(start)) {
            String s2 = m3.group(1);
            byte[] der = Base64.getDecoder().decode(CharMatcher.breakingWhitespace().removeFrom(s2));
            certs.add(der);
            start = m3.end();
        }
        if (certs.isEmpty()) {
            throw new CertificateException("No certificates found in file: " + path);
        }
        return certs;
    }

    static byte[] readPrivateKey(Path path) throws KeyException {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e2) {
            throw new KeyException("Couldn't read private key from file: " + path, e2);
        }
        String content = new String(bytes, StandardCharsets.US_ASCII);
        Matcher m3 = KEY_PATTERN.matcher(content);
        if (!m3.find()) {
            throw new KeyException("No private key found in file: " + path);
        }
        String s2 = CharMatcher.breakingWhitespace().removeFrom(m3.group(1));
        byte[] base64 = s2.getBytes(StandardCharsets.US_ASCII);
        return Base64.getDecoder().decode(base64);
    }

    private PemReader() {
    }
}

