/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.responses.networks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.rest.responses.networks.AutoValue_BSSIDsResponse;
import horse.wtf.nzyme.rest.responses.networks.BSSIDResponse;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@AutoValue
public abstract class BSSIDsResponse {
    @JsonProperty
    public abstract int total();

    @JsonProperty
    public abstract List<BSSIDResponse> bssids();

    public static BSSIDsResponse create(int total, List<BSSIDResponse> bssids) {
        Collections.sort(bssids, new BSSIDComparator());
        return BSSIDsResponse.builder().total(total).bssids(bssids).build();
    }

    public static Builder builder() {
        return new AutoValue_BSSIDsResponse.Builder();
    }

    private static class BSSIDComparator
    implements Comparator<BSSIDResponse> {
        private BSSIDComparator() {
        }

        @Override
        public int compare(BSSIDResponse b1, BSSIDResponse b2) {
            return b2.signalStrength() - b1.signalStrength();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder total(int var1);

        public abstract Builder bssids(List<BSSIDResponse> var1);

        public abstract BSSIDsResponse build();
    }
}

