/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.responses.metrics;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.rest.responses.metrics.AutoValue_TimerResponse;
import java.util.concurrent.TimeUnit;

@AutoValue
public abstract class TimerResponse {
    @JsonProperty(value="mean")
    public abstract double mean();

    @JsonProperty(value="max")
    public abstract double max();

    @JsonProperty(value="min")
    public abstract double min();

    @JsonProperty(value="stddev")
    public abstract double stddev();

    @JsonProperty(value="percentile_99")
    public abstract double percentile99();

    @JsonProperty
    public abstract long count();

    public static TimerResponse fromTimer(Timer t2) {
        Snapshot s2 = t2.getSnapshot();
        return TimerResponse.builder().mean(TimeUnit.MICROSECONDS.convert((long)s2.getMean(), TimeUnit.NANOSECONDS)).max(TimeUnit.MICROSECONDS.convert(s2.getMax(), TimeUnit.NANOSECONDS)).min(TimeUnit.MICROSECONDS.convert(s2.getMin(), TimeUnit.NANOSECONDS)).stddev(TimeUnit.MICROSECONDS.convert((long)s2.getStdDev(), TimeUnit.NANOSECONDS)).percentile99(TimeUnit.MICROSECONDS.convert((long)s2.get99thPercentile(), TimeUnit.NANOSECONDS)).count(t2.getCount()).build();
    }

    public static Builder builder() {
        return new AutoValue_TimerResponse.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder mean(double var1);

        public abstract Builder max(double var1);

        public abstract Builder min(double var1);

        public abstract Builder stddev(double var1);

        public abstract Builder percentile99(double var1);

        public abstract Builder count(long var1);

        public abstract TimerResponse build();
    }
}

