/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources.system;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opencsv.CSVWriter;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.assetinventory.Dot11AssetInventoryResponse;
import horse.wtf.nzyme.rest.responses.assetinventory.Dot11BSSIDAssetResponse;
import horse.wtf.nzyme.rest.responses.assetinventory.Dot11SSIDAssetResponse;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/api/asset-inventory")
@Produces(value={"application/json"})
@Secured
public class AssetInventoryResource {
    @Inject
    private NzymeLeader nzyme;

    @GET
    public Response dot11Assets() {
        ImmutableList.Builder ssids = new ImmutableList.Builder();
        for (Dot11NetworkDefinition ssid : this.nzyme.getConfiguration().dot11Networks()) {
            ImmutableList.Builder bssids = new ImmutableList.Builder();
            for (Dot11BSSIDDefinition bssid : ssid.bssids()) {
                bssids.add(Dot11BSSIDAssetResponse.create(bssid.address(), bssid.fingerprints()));
            }
            ssids.add(Dot11SSIDAssetResponse.create(ssid.ssid(), (List<Dot11BSSIDAssetResponse>)((Object)bssids.build()), ssid.channels(), ssid.security()));
        }
        return Response.ok(Dot11AssetInventoryResponse.create((List<Dot11SSIDAssetResponse>)((Object)ssids.build()), this.buildSSIDCSV(), this.buildBSSIDCSV())).build();
    }

    private String buildSSIDCSV() {
        StringWriter stringWriter = new StringWriter();
        CSVWriter csvWriter = new CSVWriter(stringWriter);
        csvWriter.writeNext(new String[]{"ssid", "security", "channels", "bssids"});
        for (Dot11NetworkDefinition ssid : this.nzyme.getConfiguration().dot11Networks()) {
            ArrayList<String> bssids = Lists.newArrayList();
            for (Dot11BSSIDDefinition bssid : ssid.bssids()) {
                bssids.add(bssid.address());
            }
            ArrayList<String> columns = Lists.newArrayList();
            columns.add(ssid.ssid());
            columns.add(Joiner.on(",").join(ssid.security()));
            columns.add(Joiner.on(",").join(ssid.channels()));
            columns.add(Joiner.on(",").join(bssids));
            csvWriter.writeNext((String[])columns.toArray(String[]::new));
        }
        return stringWriter.toString();
    }

    private String buildBSSIDCSV() {
        StringWriter stringWriter = new StringWriter();
        CSVWriter csvWriter = new CSVWriter(stringWriter);
        csvWriter.writeNext(new String[]{"bssid", "ssid", "fingerprint", "security"});
        for (Dot11NetworkDefinition ssid : this.nzyme.getConfiguration().dot11Networks()) {
            for (Dot11BSSIDDefinition bssid : ssid.bssids()) {
                ArrayList<String> columns = new ArrayList<String>();
                columns.add(bssid.address());
                columns.add(ssid.ssid());
                columns.add(Joiner.on(",").join(bssid.fingerprints()));
                columns.add(Joiner.on(",").join(ssid.security()));
                csvWriter.writeNext((String[])columns.toArray(String[]::new));
            }
        }
        return stringWriter.toString();
    }
}

