/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources.assets;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import horse.wtf.nzyme.rest.web.IndexHtmlGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.server.ContainerRequest;

@Path(value="/")
public class WebInterfaceAssetsResource {
    @Inject
    private MimetypesFileTypeMap mimeTypes;
    @Inject
    private IndexHtmlGenerator indexHtmlGenerator;
    private final LoadingCache<URI, FileSystem> fileSystemCache = CacheBuilder.newBuilder().maximumSize(1024L).build(new CacheLoader<URI, FileSystem>(){

        @Override
        public FileSystem load(@Nonnull URI key) throws Exception {
            try {
                return FileSystems.getFileSystem(key);
            }
            catch (FileSystemNotFoundException e2) {
                try {
                    return FileSystems.newFileSystem(key, Collections.emptyMap());
                }
                catch (FileSystemAlreadyExistsException f2) {
                    return FileSystems.getFileSystem(key);
                }
            }
        }
    });

    @GET
    @Path(value="index.html")
    public Response getIndex(@Context HttpHeaders headers) {
        return this.getDefaultResponse(headers);
    }

    @GET
    @Path(value="/{s:.*}")
    public Response getIndex(@Context ContainerRequest request, @Context HttpHeaders headers) {
        URI originalLocation = request.getRequestUri();
        if (originalLocation.getPath().endsWith("/")) {
            return this.get(request, headers, originalLocation.getPath());
        }
        URI redirect = UriBuilder.fromPath(originalLocation.getPath() + "/").build(new Object[0]);
        return Response.temporaryRedirect(redirect).build();
    }

    @Path(value="/assets/{filename: .*}")
    @GET
    public Response get(@Context Request request, @Context HttpHeaders headers, @PathParam(value="filename") String filename) {
        if (filename == null || filename.isEmpty() || "/".equals(filename) || "index.html".equals(filename)) {
            return this.getDefaultResponse(headers);
        }
        try {
            URL resourceUrl = this.getResourceUri(filename, this.getClass());
            return this.getResponse(request, filename, resourceUrl);
        }
        catch (IOException | URISyntaxException e2) {
            return this.getDefaultResponse(headers);
        }
    }

    private Response getResponse(Request request, String filename, URL resourceUrl) throws IOException, URISyntaxException {
        byte[] fileContents;
        java.nio.file.Path path;
        URI uri = resourceUrl.toURI();
        switch (resourceUrl.getProtocol()) {
            case "file": {
                path = Paths.get(uri);
                fileContents = Files.readAllBytes(path);
                break;
            }
            case "jar": {
                FileSystem fileSystem = this.fileSystemCache.getUnchecked(uri);
                path = fileSystem.getPath("web-interface/assets/" + filename, new String[0]);
                fileContents = Resources.toByteArray(resourceUrl);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a JAR or local file: " + resourceUrl);
            }
        }
        FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
        Date lastModified = Date.from(lastModifiedTime.toInstant());
        HashCode hashCode = Hashing.sha256().hashBytes(fileContents);
        EntityTag entityTag = new EntityTag(hashCode.toString());
        Response.ResponseBuilder response = request.evaluatePreconditions(lastModified, entityTag);
        if (response != null) {
            return response.build();
        }
        String contentType = MoreObjects.firstNonNull(this.mimeTypes.getContentType(filename), "application/octet-stream");
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge((int)TimeUnit.DAYS.toSeconds(365L));
        cacheControl.setNoCache(false);
        cacheControl.setPrivate(false);
        return Response.ok((Object)fileContents, contentType).tag(entityTag).cacheControl(cacheControl).lastModified(lastModified).build();
    }

    private URL getResourceUri(String filename, Class<?> aClass) throws FileNotFoundException {
        URL resourceUrl = aClass.getResource((String)(filename = "/web-interface/assets/" + (String)filename));
        if (resourceUrl == null) {
            throw new FileNotFoundException("Resource file " + (String)filename + " not found.");
        }
        return resourceUrl;
    }

    private Response getDefaultResponse(HttpHeaders headers) {
        return Response.ok(this.indexHtmlGenerator.get(headers.getRequestHeaders())).header("Content-Type", "text/html").header("X-UA-Compatible", "IE=edge").build();
    }
}

