/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.reporting.ReportBase;
import horse.wtf.nzyme.reporting.db.ExecutionLogEntry;
import horse.wtf.nzyme.reporting.db.ScheduledReportEntry;
import horse.wtf.nzyme.reporting.reports.TacticalSummaryReport;
import horse.wtf.nzyme.reporting.reports.WirelessInventoryReport;
import horse.wtf.nzyme.reporting.reports.WirelessSurveyReport;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.requests.ModifyReportReceiverEmailRequest;
import horse.wtf.nzyme.rest.requests.ScheduleReportRequest;
import horse.wtf.nzyme.rest.responses.reports.ExecutionLogEntryResponse;
import horse.wtf.nzyme.rest.responses.reports.ScheduledReportEntryResponse;
import horse.wtf.nzyme.rest.responses.reports.ScheduledReportsListResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.SchedulerException;

@Path(value="/api/reports")
@Secured
@Produces(value={"application/json"})
public class ReportsResource {
    private static final Logger LOG = LogManager.getLogger(ReportsResource.class);
    @Inject
    private NzymeLeader nzyme;

    @GET
    public Response findAllScheduledReports() {
        ArrayList<ScheduledReportEntryResponse> reports = Lists.newArrayList();
        for (ScheduledReportEntry report : this.nzyme.getSchedulingService().findAllScheduledReports()) {
            List<ExecutionLogEntry> logs = this.nzyme.getSchedulingService().findExecutionLogs(report.name());
            reports.add(this.entryToResponse(report, logs));
        }
        return Response.ok(ScheduledReportsListResponse.create(reports.size(), reports)).build();
    }

    @GET
    @Path(value="/show/{name}")
    public Response findReport(@PathParam(value="name") String name) {
        Optional<ScheduledReportEntry> result = this.nzyme.getSchedulingService().findScheduledReport(name);
        if (result.isEmpty()) {
            return Response.status(404).build();
        }
        List<ExecutionLogEntry> logs = this.nzyme.getSchedulingService().findExecutionLogs(result.get().name());
        return Response.ok(this.entryToResponse(result.get(), logs)).build();
    }

    @GET
    @Path(value="/show/{name}/execution/{execution}")
    public Response findReport(@PathParam(value="name") String name, @PathParam(value="execution") Long executionId) {
        Optional<ExecutionLogEntry> result = this.nzyme.getSchedulingService().findExecutionLog(name, executionId);
        if (result.isEmpty()) {
            return Response.status(404).build();
        }
        ExecutionLogEntry log = result.get();
        return Response.ok(ExecutionLogEntryResponse.create(log.id(), log.result(), log.message(), log.content(), log.createdAt())).build();
    }

    @POST
    @Path(value="/schedule")
    public Response scheduleReport(ScheduleReportRequest request) {
        ReportBase report;
        switch (request.reportType()) {
            case "TacticalSummary": {
                report = new TacticalSummaryReport(request.hourOfDay(), request.minuteOfHour());
                break;
            }
            case "WirelessSurvey": {
                report = new WirelessSurveyReport(request.hourOfDay(), request.minuteOfHour());
                break;
            }
            case "WirelessInventory": {
                report = new WirelessInventoryReport(request.hourOfDay(), request.minuteOfHour());
                break;
            }
            default: {
                LOG.error("No report of type [{}] found", (Object)request.reportType());
                return Response.status(404).build();
            }
        }
        try {
            String dbName = this.nzyme.getSchedulingService().scheduleReport(report);
            ArrayList<String> addedEmailReceivers = Lists.newArrayList();
            for (String email : request.emailReceivers()) {
                if (addedEmailReceivers.contains(email)) {
                    LOG.warn("Duplicate email address. Skipping.");
                    continue;
                }
                this.nzyme.getSchedulingService().addEmailReceiverToReport(dbName, email);
                addedEmailReceivers.add(email);
            }
            return Response.status(Response.Status.CREATED).build();
        }
        catch (SchedulerException e2) {
            throw new RuntimeException("Could not schedule report.", e2);
        }
    }

    @POST
    @Path(value="/show/{name}/receivers/email")
    public Response addEmailReceiver(@PathParam(value="name") String id2, ModifyReportReceiverEmailRequest request) {
        Optional<ScheduledReportEntry> result = this.nzyme.getSchedulingService().findScheduledReport(id2);
        if (result.isEmpty()) {
            return Response.status(404).build();
        }
        ScheduledReportEntry report = result.get();
        if (this.nzyme.getSchedulingService().findEmailReceiversOfReport(report.name()).contains(request.emailAddress())) {
            LOG.error("Email address already exists in receivers for this report. Skipping.");
            return Response.status(Response.Status.FORBIDDEN).build();
        }
        this.nzyme.getSchedulingService().addEmailReceiverToReport(report.name(), request.emailAddress());
        return Response.status(Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/show/{name}/receivers/email/delete")
    public Response removeEmailReceiver(@PathParam(value="name") String id2, ModifyReportReceiverEmailRequest request) {
        Optional<ScheduledReportEntry> result = this.nzyme.getSchedulingService().findScheduledReport(id2);
        if (result.isEmpty()) {
            return Response.status(404).build();
        }
        this.nzyme.getSchedulingService().removeEmailReceiverFromReport(result.get().name(), request.emailAddress());
        return Response.status(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/show/{name}")
    public Response deleteReport(@PathParam(value="name") String id2) {
        Optional<ScheduledReportEntry> result = this.nzyme.getSchedulingService().findScheduledReport(id2);
        if (result.isEmpty()) {
            return Response.status(404).build();
        }
        try {
            this.nzyme.getSchedulingService().unscheduleAndDeleteReport(id2);
        }
        catch (Exception e2) {
            LOG.error("Could not delete report.", (Throwable)e2);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    private ScheduledReportEntryResponse entryToResponse(ScheduledReportEntry x2, List<ExecutionLogEntry> executionLog) {
        CronDescriptor cronDescriptor = CronDescriptor.instance(Locale.getDefault());
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ));
        ArrayList<ExecutionLogEntryResponse> executionLogResponse = Lists.newArrayList();
        if (executionLog != null) {
            for (ExecutionLogEntry log : executionLog) {
                executionLogResponse.add(ExecutionLogEntryResponse.create(log.id(), log.result(), log.message(), null, log.createdAt()));
            }
        }
        return ScheduledReportEntryResponse.create(x2.name().split("-")[1], x2.name(), x2.createdAt(), x2.nextFireTime(), x2.previousFireTime(), x2.triggerState(), x2.cronExpression(), cronDescriptor.describe(cronParser.parse(x2.cronExpression())), this.nzyme.getSchedulingService().findEmailReceiversOfReport(x2.name()), executionLogResponse);
    }
}

