/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources;

import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.bandits.Contact;
import horse.wtf.nzyme.bandits.engine.ContactRecordAggregation;
import horse.wtf.nzyme.bandits.engine.ContactRecorder;
import horse.wtf.nzyme.dot11.deauth.db.DeauthenticationMonitorRecording;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.measurements.Measurement;
import horse.wtf.nzyme.measurements.MeasurementType;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.alerts.AlertDetailsResponse;
import horse.wtf.nzyme.rest.responses.alerts.AlertsListResponse;
import horse.wtf.nzyme.rest.responses.bandits.ContactResponse;
import horse.wtf.nzyme.rest.responses.dashboard.DashboardResponse;
import horse.wtf.nzyme.rest.responses.system.ProbeResponse;
import horse.wtf.nzyme.rest.responses.system.ProbesListResponse;
import horse.wtf.nzyme.systemstatus.SystemStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/api/dashboard")
@Secured
@Produces(value={"application/json"})
public class DashboardResource {
    private static final Logger LOG = LogManager.getLogger(DashboardResource.class);
    private static final String MEASUREMENTS_QUERY = "SELECT * FROM measurements WHERE measurement_type = ? AND created_at > (current_timestamp at time zone 'UTC' - interval '1 day') ORDER BY created_at ASC;";
    private static final String DEAUTH_QUERY = "SELECT * FROM deauth_monitor WHERE created_at > (current_timestamp - interval '1 day') ORDER BY created_at ASC;";
    @Inject
    private NzymeLeader nzyme;

    @GET
    public Response dashboard() {
        long activeAlerts = this.nzyme.getAlertsService().findActiveAlerts().size();
        long activeContacts = 0L;
        ArrayList<AlertDetailsResponse> alerts = Lists.newArrayList();
        for (Alert alert : this.nzyme.getAlertsService().findAllAlerts(5, 0).values()) {
            alerts.add(AlertDetailsResponse.fromAlert(alert));
        }
        for (Contact contact : this.nzyme.getContactManager().findContacts().values()) {
            if (!contact.isActive()) continue;
            ++activeContacts;
        }
        SystemStatus.HEALTH systemHealthStatus = this.nzyme.getSystemStatus().decideHealth(this.nzyme);
        Map<String, Long> frameThroughputHistogram = this.buildMeasurementHistogram(this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery(MEASUREMENTS_QUERY).bind(0, (Object)MeasurementType.DOT11_FRAME_COUNT)).mapTo(Measurement.class).list()));
        Map<String, Long> deauthHistogram = this.buildDeauthHistogram(this.nzyme.getDatabase().withHandle(handle -> handle.createQuery(DEAUTH_QUERY).mapTo(DeauthenticationMonitorRecording.class).list()));
        ArrayList<ContactResponse> contacts = Lists.newArrayList();
        for (Contact contact : this.nzyme.getContactManager().findContacts(5, 0).values()) {
            if (contact.bandit() == null || contact.bandit().uuid() == null) {
                LOG.warn("Skipping unexpected incomplete contact [{}].", (Object)contact);
                continue;
            }
            Optional<List<ContactRecordAggregation>> ssids = this.nzyme.getContactManager().findRecordValuesOfContact(contact.uuid(), ContactRecorder.RECORD_TYPE.SSID);
            Optional<List<ContactRecordAggregation>> bssids = this.nzyme.getContactManager().findRecordValuesOfContact(contact.uuid(), ContactRecorder.RECORD_TYPE.BSSID);
            contacts.add(ContactResponse.create(contact.uuid(), contact.frameCount(), contact.firstSeen(), contact.lastSeen(), contact.isActive(), contact.lastSignal(), contact.bandit().uuid().toString(), contact.bandit().name(), contact.sourceRole().toString(), contact.sourceName(), ssids.orElse(Collections.emptyList()), bssids.orElse(Collections.emptyList())));
        }
        ArrayList<ProbeResponse> probes = Lists.newArrayList();
        for (Dot11Probe probe : this.nzyme.getProbes()) {
            probes.add(ProbeResponse.create(probe.getName(), probe.getClass().getSimpleName(), probe.getConfiguration().networkInterfaceName(), probe.isInLoop(), probe.isActive(), probe.getConfiguration().channels(), probe.getCurrentChannel(), probe.getTotalFrames()));
        }
        return Response.ok(DashboardResponse.create(activeAlerts, activeContacts, systemHealthStatus, frameThroughputHistogram, deauthHistogram, this.nzyme.getConfiguration().deauth() == null ? null : Integer.valueOf(this.nzyme.getConfiguration().deauth().globalThreshold()), AlertsListResponse.create(alerts.size(), alerts), contacts, ProbesListResponse.create(probes.size(), probes))).build();
    }

    private Map<String, Long> buildMeasurementHistogram(List<Measurement> measurements) {
        Map<String, Long> clientCountHistogram = this.buildEmptyDailyHistogram();
        if (measurements != null && !measurements.isEmpty()) {
            for (Measurement measurement : measurements) {
                clientCountHistogram.put(measurement.createdAt().withZone(DateTimeZone.UTC).withSecondOfMinute(0).withMillisOfSecond(0).toString(), measurement.value());
            }
        }
        return clientCountHistogram;
    }

    private Map<String, Long> buildDeauthHistogram(List<DeauthenticationMonitorRecording> recordings) {
        Map<String, Long> deauthHistogram = this.buildEmptyDailyHistogram();
        if (recordings != null && !recordings.isEmpty()) {
            for (DeauthenticationMonitorRecording recording : recordings) {
                deauthHistogram.put(recording.createdAt().withZone(DateTimeZone.UTC).withSecondOfMinute(0).withMillisOfSecond(0).toString(), recording.totalFrameCount());
            }
        }
        return deauthHistogram;
    }

    private Map<String, Long> buildEmptyDailyHistogram() {
        TreeMap<String, Long> histo = new TreeMap<String, Long>();
        for (int i2 = 1; i2 < 1440; ++i2) {
            histo.put(DateTime.now(DateTimeZone.UTC).minusMinutes(i2).withSecondOfMinute(0).withMillisOfSecond(0).toString(), 0L);
        }
        return histo;
    }
}

