/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.Contact;
import horse.wtf.nzyme.bandits.engine.ContactRecordAggregation;
import horse.wtf.nzyme.bandits.engine.ContactRecorder;
import horse.wtf.nzyme.bandits.engine.ContactRecorderHistogramEntry;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierFactory;
import horse.wtf.nzyme.bandits.trackers.Tracker;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.requests.CreateBanditIdentifierRequest;
import horse.wtf.nzyme.rest.requests.CreateBanditRequest;
import horse.wtf.nzyme.rest.requests.UpdateBanditRequest;
import horse.wtf.nzyme.rest.responses.bandits.BanditIdentifierResponse;
import horse.wtf.nzyme.rest.responses.bandits.BanditResponse;
import horse.wtf.nzyme.rest.responses.bandits.BanditsListResponse;
import horse.wtf.nzyme.rest.responses.bandits.ContactDetailsResponse;
import horse.wtf.nzyme.rest.responses.bandits.ContactResponse;
import horse.wtf.nzyme.rest.responses.bandits.identifiers.IdentifierTypesResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

@Path(value="/api/bandits")
@Secured
@Produces(value={"application/json"})
public class BanditsResource {
    private static final Logger LOG = LogManager.getLogger(BanditsResource.class);
    @Inject
    private NzymeLeader nzyme;

    @GET
    public Response findAll() {
        ArrayList<BanditResponse> bandits = Lists.newArrayList();
        for (Bandit x2 : this.nzyme.getContactManager().getBandits().values()) {
            if (x2.databaseId() == null) {
                LOG.error("Uninitialized bandit in BanditIdentifier. Skipping.");
                continue;
            }
            List<ContactResponse> contacts = this.buildContactsResponse(x2, false);
            bandits.add(BanditResponse.create(x2.uuid(), x2.databaseId(), x2.name(), x2.description(), x2.createdAt(), x2.updatedAt(), x2.readOnly(), this.findLastContact(contacts), this.anyActiveContact(contacts), this.trackedBy(x2), this.buildIdentifiersResponse(x2), contacts));
        }
        return Response.ok(BanditsListResponse.create(bandits, bandits.size())).build();
    }

    @GET
    @Path(value="/show/{uuid}")
    public Response findOne(@PathParam(value="uuid") String id2) {
        UUID uuid;
        if (Strings.isNullOrEmpty(id2)) {
            LOG.warn("Bandit ID was null or empty.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        try {
            uuid = UUID.fromString(id2);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("Invalid Bandit UUID", (Throwable)e2);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        Bandit bandit = this.nzyme.getContactManager().getBandits().get(uuid);
        if (bandit == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        List<ContactResponse> contacts = this.buildContactsResponse(bandit, true);
        return Response.ok(BanditResponse.create(bandit.uuid(), bandit.databaseId(), bandit.name(), bandit.description(), bandit.createdAt(), bandit.updatedAt(), bandit.readOnly(), this.findLastContact(contacts), this.anyActiveContact(contacts), this.trackedBy(bandit), this.buildIdentifiersResponse(bandit), contacts)).build();
    }

    @POST
    public Response create(CreateBanditRequest request) {
        if (request == null) {
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        if (Strings.isNullOrEmpty(request.name()) || Strings.isNullOrEmpty(request.description())) {
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        this.nzyme.getContactManager().registerBandit(Bandit.create(null, UUID.randomUUID(), request.name(), request.description(), false, null, null, null));
        return Response.status(Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/show/{uuid}")
    public Response delete(@PathParam(value="uuid") String id2) {
        UUID uuid;
        if (Strings.isNullOrEmpty(id2)) {
            LOG.warn("Bandit ID was null or empty.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        for (Tracker tracker : this.nzyme.getTrackerManager().getTrackers().values()) {
            if (tracker.getTrackingMode() == null || !tracker.getTrackingMode().equals(id2)) continue;
            LOG.error("Cannot delete bandit that is currently actively tracked by trackers.");
            return Response.status(401).build();
        }
        try {
            uuid = UUID.fromString(id2);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("Invalid Bandit UUID", (Throwable)e2);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        Optional<Bandit> optionalBandit = this.nzyme.getContactManager().findBanditByUUID(uuid);
        if (!optionalBandit.isPresent()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        if (optionalBandit.get().readOnly().booleanValue()) {
            LOG.warn("Bandit [{}] is read only.", (Object)uuid);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        this.nzyme.getContactManager().removeBandit(uuid);
        return Response.status(Response.Status.OK).build();
    }

    @PUT
    @Path(value="/show/{uuid}")
    public Response update(@PathParam(value="uuid") String id2, UpdateBanditRequest request) {
        UUID uuid;
        if (Strings.isNullOrEmpty(id2)) {
            LOG.warn("Bandit ID was null or empty.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        try {
            uuid = UUID.fromString(id2);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("Invalid Bandit UUID", (Throwable)e2);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        if (request == null) {
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        if (Strings.isNullOrEmpty(request.name()) || Strings.isNullOrEmpty(request.description())) {
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        Optional<Bandit> optionalBandit = this.nzyme.getContactManager().findBanditByUUID(uuid);
        if (!optionalBandit.isPresent()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        if (optionalBandit.get().readOnly().booleanValue()) {
            LOG.warn("Bandit [{}] is read only.", (Object)uuid);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        this.nzyme.getContactManager().updateBandit(uuid, request.description(), request.name());
        return Response.status(Response.Status.OK).build();
    }

    @GET
    @Path(value="/identifiers/types")
    public Response findAllIdentifierTypes() {
        ArrayList<String> types = Lists.newArrayList();
        for (BanditIdentifier.TYPE type : BanditIdentifier.TYPE.values()) {
            types.add(type.toString());
        }
        return Response.ok(IdentifierTypesResponse.create(types.size(), types)).build();
    }

    @POST
    @Path(value="/show/{banditUUID}/identifiers")
    public Response createIdentifier(@PathParam(value="banditUUID") String banditUUID, CreateBanditIdentifierRequest request) {
        BanditIdentifier identifier;
        BanditIdentifier.TYPE type;
        UUID uuid;
        if (Strings.isNullOrEmpty(banditUUID)) {
            LOG.warn("Bandit ID was null or empty.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        for (Tracker tracker : this.nzyme.getTrackerManager().getTrackers().values()) {
            if (tracker.getTrackingMode() == null || !tracker.getTrackingMode().equals(banditUUID)) continue;
            LOG.error("Cannot modify bandit that is currently actively tracked by trackers.");
            return Response.status(401).build();
        }
        try {
            uuid = UUID.fromString(banditUUID);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("Invalid Bandit UUID", (Throwable)e2);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        Optional<Bandit> bandit = this.nzyme.getContactManager().findBanditByUUID(uuid);
        if (!bandit.isPresent()) {
            LOG.warn("Bandit with UUID <{}> not found.", (Object)banditUUID);
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        if (bandit.get().readOnly().booleanValue()) {
            LOG.warn("Bandit [{}] is read only.", (Object)uuid);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        if (request == null) {
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        try {
            type = BanditIdentifier.TYPE.valueOf(request.type());
        }
        catch (IllegalArgumentException e3) {
            LOG.warn("Invalid identifier type.", (Throwable)e3);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        try {
            identifier = BanditIdentifierFactory.create(type, request.configuration(), null, null);
        }
        catch (BanditIdentifierFactory.MappingException | BanditIdentifierFactory.NoSerializerException e4) {
            LOG.error("Could not create bandit identifier object.", (Throwable)e4);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        this.nzyme.getContactManager().registerIdentifier(bandit.get(), identifier);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/show/{banditUUID}/identifiers/{identifierUUID}")
    public Response deleteIdentifier(@PathParam(value="banditUUID") String bUUID, @PathParam(value="identifierUUID") String iUUID) {
        UUID identifierUUID;
        UUID banditUUID;
        if (Strings.isNullOrEmpty(bUUID) || Strings.isNullOrEmpty(iUUID)) {
            LOG.warn("UUID was null or empty.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        for (Tracker tracker : this.nzyme.getTrackerManager().getTrackers().values()) {
            if (tracker.getTrackingMode() == null || !tracker.getTrackingMode().equals(bUUID)) continue;
            LOG.error("Cannot modify bandit that is currently actively tracked by trackers.");
            return Response.status(401).build();
        }
        try {
            banditUUID = UUID.fromString(bUUID);
            identifierUUID = UUID.fromString(iUUID);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("Invalid UUID", (Throwable)e2);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        Optional<Bandit> optionalBandit = this.nzyme.getContactManager().findBanditByUUID(banditUUID);
        if (!optionalBandit.isPresent()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        if (optionalBandit.get().readOnly().booleanValue()) {
            LOG.warn("Bandit [{}] is read only.", (Object)banditUUID);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        this.nzyme.getContactManager().removeIdentifier(identifierUUID);
        return Response.ok().build();
    }

    @GET
    @Path(value="/show/{banditUUID}/contacts/{contactUUID}")
    public Response findContactOfBandit(@PathParam(value="banditUUID") String bUUID, @PathParam(value="contactUUID") String cUUID, @QueryParam(value="detailed_ssids") String detailedSSIDsQ, @QueryParam(value="detailed_bssids") String detailedBSSIDsQ) {
        UUID contactUUID;
        UUID banditUUID;
        if (Strings.isNullOrEmpty(bUUID) || Strings.isNullOrEmpty(cUUID)) {
            LOG.warn("UUID was null or empty.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        List<String> detailedSSIDs = detailedSSIDsQ != null ? Lists.newArrayList(Splitter.on(",").split(detailedSSIDsQ)) : Collections.emptyList();
        List<String> detailedBSSIDs = detailedBSSIDsQ != null ? Lists.newArrayList(Splitter.on(",").split(detailedBSSIDsQ)) : Collections.emptyList();
        try {
            banditUUID = UUID.fromString(bUUID);
            contactUUID = UUID.fromString(cUUID);
        }
        catch (IllegalArgumentException e2) {
            LOG.error("Invalid UUID.", (Throwable)e2);
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        Optional<Bandit> oBandit = this.nzyme.getContactManager().findBanditByUUID(banditUUID);
        if (oBandit.isEmpty()) {
            LOG.error("Bandit not found.");
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        Bandit bandit = oBandit.get();
        Optional<Contact> oContact = this.nzyme.getContactManager().findContactOfBandit(bandit, contactUUID);
        if (oContact.isEmpty()) {
            LOG.error("Contact not found.");
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        Contact contact = oContact.get();
        Optional<List<ContactRecordAggregation>> ssids = this.nzyme.getContactManager().findRecordValuesOfContact(contact.uuid(), ContactRecorder.RECORD_TYPE.SSID);
        Optional<List<ContactRecordAggregation>> bssids = this.nzyme.getContactManager().findRecordValuesOfContact(contact.uuid(), ContactRecorder.RECORD_TYPE.BSSID);
        Optional<Map<String, List<ContactRecorderHistogramEntry>>> ssidRawHistograms = this.nzyme.getContactManager().findRecordingHistogramsOfContact(contact.uuid(), detailedSSIDs, ContactRecorder.RECORD_TYPE.SSID);
        Optional<Map<String, List<ContactRecorderHistogramEntry>>> bssidRawHistograms = this.nzyme.getContactManager().findRecordingHistogramsOfContact(contact.uuid(), detailedBSSIDs, ContactRecorder.RECORD_TYPE.BSSID);
        return Response.ok(ContactDetailsResponse.create(contact.uuid(), contact.frameCount(), contact.firstSeen(), contact.lastSeen(), contact.isActive(), contact.lastSignal(), bandit.uuid().toString(), bandit.name(), contact.sourceRole().toString(), contact.sourceName(), ssids.orElse(Collections.emptyList()), bssids.orElse(Collections.emptyList()), this.buildContactRecordHistogram(ssidRawHistograms, ContactRecorder.VALUE_TYPE.FRAME_COUNT).orElse(Maps.newHashMap()), this.buildContactRecordHistogram(bssidRawHistograms, ContactRecorder.VALUE_TYPE.FRAME_COUNT).orElse(Maps.newHashMap()), this.buildContactRecordHistogram(ssidRawHistograms, ContactRecorder.VALUE_TYPE.SIGNAL_STRENGTH).orElse(Maps.newHashMap()), this.buildContactRecordHistogram(bssidRawHistograms, ContactRecorder.VALUE_TYPE.SIGNAL_STRENGTH).orElse(Maps.newHashMap()))).build();
    }

    private Optional<Map<String, Map<String, Long>>> buildContactRecordHistogram(Optional<Map<String, List<ContactRecorderHistogramEntry>>> x2, ContactRecorder.VALUE_TYPE valueType) {
        if (x2.isEmpty()) {
            return Optional.empty();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<ContactRecorderHistogramEntry>> ssid : x2.get().entrySet()) {
            HashMap<String, Long> ssidResult = Maps.newHashMap();
            for (ContactRecorderHistogramEntry value : ssid.getValue()) {
                long selectedValue;
                switch (valueType) {
                    case FRAME_COUNT: {
                        selectedValue = value.frameCount();
                        break;
                    }
                    case SIGNAL_STRENGTH: {
                        selectedValue = value.signalStrength();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Value type not implemented for histogram translation.");
                    }
                }
                ssidResult.put(value.createdAt().toString(), selectedValue);
            }
            result.put(ssid.getKey(), ssidResult);
        }
        return Optional.of(result);
    }

    private List<BanditIdentifierResponse> buildIdentifiersResponse(Bandit bandit) {
        ImmutableList.Builder response = new ImmutableList.Builder();
        if (bandit.identifiers() != null) {
            for (BanditIdentifier identifier : bandit.identifiers()) {
                response.add(BanditIdentifierResponse.create(identifier.configuration(), identifier.descriptor().type(), identifier.descriptor().description(), identifier.descriptor().matches(), identifier.getDatabaseID(), identifier.getUuid()));
            }
        }
        return response.build();
    }

    private List<ContactResponse> buildContactsResponse(Bandit bandit, boolean includeContactRecords) {
        ImmutableList.Builder response = new ImmutableList.Builder();
        for (Contact contact : this.nzyme.getContactManager().findContactsOfBandit(bandit)) {
            Optional<Object> bssids;
            Optional<Object> ssids;
            if (includeContactRecords) {
                ssids = this.nzyme.getContactManager().findRecordValuesOfContact(contact.uuid(), ContactRecorder.RECORD_TYPE.SSID);
                bssids = this.nzyme.getContactManager().findRecordValuesOfContact(contact.uuid(), ContactRecorder.RECORD_TYPE.BSSID);
            } else {
                ssids = Optional.empty();
                bssids = Optional.empty();
            }
            response.add(ContactResponse.create(contact.uuid(), contact.frameCount(), contact.firstSeen(), contact.lastSeen(), contact.isActive(), contact.lastSignal(), bandit.uuid().toString(), bandit.name(), contact.sourceRole().toString(), contact.sourceName(), ssids.orElse(Collections.emptyList()), bssids.orElse(Collections.emptyList())));
        }
        return response.build();
    }

    private DateTime findLastContact(List<ContactResponse> contacts) {
        if (contacts.isEmpty()) {
            return null;
        }
        DateTime last = contacts.get(0).lastSeen();
        for (ContactResponse contact : contacts) {
            if (!contact.lastSeen().isAfter(last)) continue;
            last = contact.lastSeen();
        }
        return last;
    }

    private boolean anyActiveContact(List<ContactResponse> contacts) {
        for (ContactResponse contact : contacts) {
            if (!contact.isActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private List<UUID> trackedBy(Bandit bandit) {
        ArrayList<UUID> trackedBy = Lists.newArrayList();
        for (Tracker tracker : this.nzyme.getTrackerManager().getTrackers().values()) {
            if (tracker.getLastSeen().isBefore(DateTime.now().minusSeconds(30)) || this.nzyme.getGroundStation().trackerHasPendingCancelTrackingRequest(tracker.getName()) || !tracker.getTrackingMode().equals(bandit.uuid().toString())) continue;
            trackedBy.add(UUID.fromString(tracker.getTrackingMode()));
        }
        return trackedBy;
    }
}

