/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.reporting;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.configuration.ReportingConfiguration;
import horse.wtf.nzyme.reporting.ReportBase;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.mail.util.ByteArrayDataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;
import org.simplejavamail.mailer.internal.MailerRegularBuilderImpl;

public abstract class ReportJob
implements Job {
    private static final Logger LOG = LogManager.getLogger(ReportJob.class);
    protected static final DateTimeFormatter LONG_DATETIME = DateTimeFormat.forPattern("MMMM dd, yyyy, HH:mm:ss aa (Z ZZZZ)");
    protected static final DateTimeFormatter LONG_DATETIME_LESS_ZONE = DateTimeFormat.forPattern("MMMM dd, yyyy, HH:mm:ss aa (Z)");
    private final Configuration templateConfig = new Configuration(Configuration.VERSION_2_3_30);

    public ReportJob() {
        this.templateConfig.setClassForTemplateLoading(this.getClass(), "/");
        this.templateConfig.setDefaultEncoding("UTF-8");
        this.templateConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.templateConfig.setLogTemplateExceptions(false);
        this.templateConfig.setWrapUncheckedExceptions(true);
        this.templateConfig.setFallbackOnNullLoopVariable(false);
    }

    protected Configuration getTemplateConfig() {
        return this.templateConfig;
    }

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        List<String> emailReceivers;
        NzymeLeader nzyme = null;
        String jobName = null;
        try {
            SchedulerContext schedContext = context.getScheduler().getContext();
            nzyme = (NzymeLeader)schedContext.get("nzyme");
            jobName = context.getJobDetail().getKey().getName();
            emailReceivers = nzyme.getSchedulingService().findEmailReceiversOfReport(jobName);
        }
        catch (SchedulerException e2) {
            if (nzyme != null) {
                nzyme.getSchedulingService().logReportExecutionResult(jobName, ReportBase.EXECUTION_RESULT.ERROR, "Could not initialize report. [" + e2.getMessage() + "] - See nzyme log for more details.", null);
            }
            throw new JobExecutionException(e2);
        }
        try {
            String reportContent = this.runReport(nzyme, emailReceivers);
            if (emailReceivers != null && !emailReceivers.isEmpty()) {
                if (nzyme.getConfiguration().reporting().email() == null) {
                    LOG.error("Report has email receivers configured but reporting has no SMTP settings. Please refer to the documentation. Cannot send emails.");
                } else {
                    LOG.debug("Sending report email to: {}", (Object)emailReceivers);
                    ReportingConfiguration.Email emailConfig = nzyme.getConfiguration().reporting().email();
                    Mailer mailer = ((MailerRegularBuilderImpl)MailerBuilder.withSMTPServer(emailConfig.host(), emailConfig.port(), emailConfig.username(), emailConfig.password()).withTransportStrategy(emailConfig.transportStrategy()).clearEmailAddressCriteria()).buildMailer();
                    LOG.info("Sending report emails.");
                    for (String receiver : emailReceivers) {
                        LOG.debug("Sending report email to <{}>", (Object)receiver);
                        try {
                            Email email = EmailBuilder.startingBlank().to(receiver).from(emailConfig.from()).withSubject(emailConfig.subjectPrefix() + " Report: " + this.getName()).withPlainText("Report is attached. - Nzyme.\n\n(Download and open in browser for best display quality.)").withAttachment("report.html", new ByteArrayDataSource(reportContent.getBytes(StandardCharsets.UTF_8), "text/html")).buildEmail();
                            mailer.sendMail(email);
                        }
                        catch (Exception e3) {
                            LOG.error("Could not send Email.", (Throwable)e3);
                        }
                    }
                }
            } else {
                LOG.info("Report has no email receivers configured.");
            }
            nzyme.getSchedulingService().logReportExecutionResult(jobName, ReportBase.EXECUTION_RESULT.SUCCESS, "Report executed successfully.", reportContent);
        }
        catch (Exception e4) {
            LOG.error("Could not execute report", (Throwable)e4);
            nzyme.getSchedulingService().logReportExecutionResult(jobName, ReportBase.EXECUTION_RESULT.ERROR, "Could not execute report. [" + e4.getMessage() + "] - See nzyme log for more details.", null);
            throw e4;
        }
    }

    public abstract String runReport(NzymeLeader var1, List<String> var2) throws JobExecutionException;

    public abstract String getName();
}

