/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.remote.forwarders;

import com.google.protobuf.ByteString;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.remote.forwarders.Forwarder;
import horse.wtf.nzyme.remote.protobuf.NzymeMessage;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class UDPForwarder
implements Forwarder {
    private static final Logger LOG = LogManager.getLogger(UDPForwarder.class);
    private final String nzymeId;
    private InetSocketAddress address;
    private DatagramSocket socket;

    public UDPForwarder(InetSocketAddress address, String nzymeId) {
        LOG.info("Initializing UDP forwarder to [{}]", (Object)address);
        this.address = address;
        this.nzymeId = nzymeId;
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException e2) {
            throw new RuntimeException("Could not create UDP socket.", e2);
        }
    }

    @Override
    public void forward(Dot11Frame frame) {
        try {
            byte[] forwardedFrame = NzymeMessage.Message.newBuilder().setMessageType("frame").setFrame(NzymeMessage.Frame.newBuilder().setFrameType("802.11").setDot11Frame(NzymeMessage.Dot11Frame.newBuilder().setRecordedAt(new DateTime().getMillis()).setSource(this.nzymeId).setFrameType(frame.getClass().getCanonicalName()).setFrameHeader(ByteString.copyFrom(frame.header())).setFramePayload(ByteString.copyFrom(frame.payload())).setFrameMeta(this.buildMetaBuf(frame.meta())).build()).build()).build().toByteArray();
            this.socket.send(new DatagramPacket(forwardedFrame, forwardedFrame.length, this.address));
        }
        catch (Exception e2) {
            LOG.error("Could not forward frame.", (Throwable)e2);
        }
    }

    private NzymeMessage.FrameMeta buildMetaBuf(Dot11MetaInformation meta) {
        return NzymeMessage.FrameMeta.newBuilder().setIsMalformed(meta.isMalformed()).setAntennaSignal(meta.getAntennaSignal()).setSignalQuality(meta.getSignalQuality()).setFrequency(meta.getFrequency()).setChannel(meta.getChannel()).setMacTimestamp(meta.getMacTimestamp()).setIsWEP(meta.isWep()).build();
    }
}

