/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.processing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class FrameProcessor {
    private final Monitor monitor = new Monitor();
    private final AtomicLong recentDot11FrameCount;
    private final AtomicLong recentDot11FrameCountTemp;
    private final List<Dot11FrameInterceptor> dot11Interceptors = Lists.newArrayList();

    public FrameProcessor() {
        this.recentDot11FrameCount = new AtomicLong(0L);
        this.recentDot11FrameCountTemp = new AtomicLong(0L);
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("frameproc-recent-cleaner-%d").build()).scheduleAtFixedRate(this::resetRecentDot11FrameCount, 1L, 1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDot11Frame(Dot11Frame frame) {
        this.monitor.enter();
        try {
            this.recentDot11FrameCountTemp.incrementAndGet();
            for (Dot11FrameInterceptor interceptor : this.dot11Interceptors) {
                if (interceptor.forSubtype() != frame.frameType()) continue;
                interceptor.intercept(frame);
            }
        }
        finally {
            this.monitor.leave();
        }
    }

    public void registerDot11Interceptors(List<Dot11FrameInterceptor> interceptors) {
        for (Dot11FrameInterceptor interceptor : interceptors) {
            this.registerDot11Interceptor(interceptor);
        }
    }

    public void registerDot11Interceptor(Dot11FrameInterceptor interceptor) {
        this.monitor.enter();
        try {
            this.dot11Interceptors.add(interceptor);
        }
        finally {
            this.monitor.leave();
        }
    }

    public ImmutableList<Dot11FrameInterceptor> getDot11Interceptors() {
        return ImmutableList.copyOf(this.dot11Interceptors);
    }

    public long getRecentFrameCount() {
        return this.recentDot11FrameCount.get();
    }

    public void resetRecentDot11FrameCount() {
        this.recentDot11FrameCount.set(this.recentDot11FrameCountTemp.get());
        this.recentDot11FrameCountTemp.set(0L);
    }
}

