/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals.sigidx;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.networks.BSSID;
import horse.wtf.nzyme.dot11.networks.Channel;
import horse.wtf.nzyme.dot11.networks.SSID;
import horse.wtf.nzyme.periodicals.Periodical;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignalIndexHistogramWriter
extends Periodical {
    private static final Logger LOG = LogManager.getLogger(SignalIndexHistogramWriter.class);
    private final NzymeLeader nzyme;
    private final ObjectMapper om;

    public SignalIndexHistogramWriter(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.om = new ObjectMapper();
    }

    @Override
    protected void execute() {
        LOG.debug("Updating signal index histograms.");
        ArrayList<BSSID> bssids = Lists.newArrayList(this.nzyme.getNetworks().getBSSIDs().values());
        for (BSSID bssid : bssids) {
            ArrayList<SSID> ssids = Lists.newArrayList(bssid.ssids().values());
            for (SSID ssid : ssids) {
                if (!ssid.isHumanReadable()) continue;
                ArrayList<Channel> channels = Lists.newArrayList(ssid.channels().values());
                for (Channel channel : channels) {
                    String histogram;
                    try {
                        histogram = this.om.writeValueAsString(channel.signalStrengthTable().getSignalDistributionHistogram());
                    }
                    catch (JsonProcessingException e2) {
                        LOG.error("Could not write signal index histogram to JSON for BSSID [{}].", (Object)bssid, (Object)e2);
                        continue;
                    }
                    this.nzyme.getDatabase().useHandle(handle -> handle.execute("INSERT INTO sigidx_histogram_history(bssid, ssid, channel, histogram, created_at) VALUES(?, ?, ?, ?, current_timestamp at time zone 'UTC')", bssid.bssid(), ssid.nameSafe(), channel.channelNumber(), histogram));
                }
            }
        }
    }

    @Override
    public String getName() {
        return "SignalIndexHistogramWriter";
    }
}

