/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals.sigidx;

import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.database.Database;
import horse.wtf.nzyme.periodicals.Periodical;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignalIndexHistogramCleaner
extends Periodical {
    private static final Logger LOG = LogManager.getLogger(SignalIndexHistogramCleaner.class);
    private final Database database;

    public SignalIndexHistogramCleaner(NzymeLeader nzyme) {
        this.database = nzyme.getDatabase();
    }

    @Override
    protected void execute() {
        try {
            LOG.debug("Retention cleaning signal index history values.");
            this.database.useHandle(handle -> handle.execute("DELETE FROM sigidx_histogram_history WHERE created_at < (current_timestamp at time zone 'UTC' - interval '24 hours')", new Object[0]));
        }
        catch (Exception e2) {
            LOG.error("Could not retention clean signal index history information.", (Throwable)e2);
        }
    }

    @Override
    public String getName() {
        return "SignalIndexHistogramCleaner";
    }
}

