/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals.alerting.tracks;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.MultipleTrackAlert;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.dot11.networks.BSSID;
import horse.wtf.nzyme.dot11.networks.Channel;
import horse.wtf.nzyme.dot11.networks.SSID;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.SignalWaterfallHistogramLoader;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.Track;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.TrackDetector;
import horse.wtf.nzyme.periodicals.Periodical;
import horse.wtf.nzyme.util.MetricNames;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class SignalTrackMonitor
extends Periodical {
    private static final Logger LOG = LogManager.getLogger(SignalTrackMonitor.class);
    private final NzymeLeader nzyme;
    private final Timer timer;

    public SignalTrackMonitor(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.timer = nzyme.getMetrics().timer(MetricRegistry.name(MetricNames.SIGNAL_TRACK_MONITOR_TIMING, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        Timer.Context ctx = this.timer.time();
        try {
            for (BSSID bssid : this.nzyme.getNetworks().getBSSIDs().values()) {
                for (SSID ssid : bssid.ssids().values()) {
                    Dot11NetworkDefinition network;
                    if (!ssid.isHumanReadable() || !this.nzyme.getConfiguration().ourSSIDs().contains(ssid.name()) || (network = this.nzyme.getConfiguration().findNetworkDefinition(bssid.bssid(), ssid.name())) == null) continue;
                    Dot11BSSIDDefinition config = this.nzyme.getConfiguration().findBSSIDDefinition(bssid.bssid(), ssid.name());
                    TrackDetector.TrackDetectorConfig tdc = config == null || config.trackDetectorConfig() == null ? TrackDetector.DEFAULT_CONFIG : config.trackDetectorConfig();
                    SignalWaterfallHistogramLoader signalWaterfallHistogramLoader = new SignalWaterfallHistogramLoader(this.nzyme);
                    for (Channel channel : ssid.channels().values()) {
                        TrackDetector trackDetector = new TrackDetector(signalWaterfallHistogramLoader.load(bssid, ssid, channel, 900));
                        List<Track> tracks = trackDetector.detect(tdc);
                        if (tracks.size() <= 1) continue;
                        this.nzyme.getAlertsService().handle(MultipleTrackAlert.create(DateTime.now(), ssid.name(), bssid.bssid(), channel.channelNumber(), tracks.size()));
                    }
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Signal Track Monitor run failed.", (Throwable)e2);
        }
        finally {
            ctx.stop();
        }
    }

    @Override
    public String getName() {
        return "SignalTrackMonitor";
    }
}

