/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals.alerting.beaconrate;

import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.database.Database;
import horse.wtf.nzyme.dot11.networks.BSSID;
import horse.wtf.nzyme.dot11.networks.Networks;
import horse.wtf.nzyme.dot11.networks.SSID;
import horse.wtf.nzyme.periodicals.Periodical;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeaconRateWriter
extends Periodical {
    private static final Logger LOG = LogManager.getLogger(BeaconRateWriter.class);
    private final Networks networks;
    private final Database database;

    public BeaconRateWriter(NzymeLeader nzyme) {
        this.networks = nzyme.getNetworks();
        this.database = nzyme.getDatabase();
    }

    @Override
    protected void execute() {
        try {
            for (BSSID bssid : this.networks.getBSSIDs().values()) {
                for (SSID ssid : bssid.ssids().values()) {
                    if (!ssid.isHumanReadable()) continue;
                    this.database.useHandle(handle -> handle.execute("INSERT INTO beacon_rate_history(bssid, ssid, beacon_rate, created_at) VALUES(?, ?, ?, current_timestamp at time zone 'UTC')", bssid.bssid().toLowerCase(), ssid.name(), ssid.beaconCount.get()));
                    ssid.beaconCount.set(0);
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Could not write beacon rate information.", (Throwable)e2);
        }
    }

    @Override
    public String getName() {
        return "BeaconRateWriter";
    }
}

