/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.ouis;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.util.MetricNames;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OUIManager {
    private static final Logger LOG = LogManager.getLogger(OUIManager.class);
    private static final String OUI_SOURCE = "http://standards-oui.ieee.org/oui/oui.txt";
    private static final Pattern LINE_REGEX = Pattern.compile("^(.+)\\b.+\\(base 16\\)(.+)$");
    private ImmutableMap<String, String> ouis;
    private final NzymeLeader nzyme;
    private final Timer lookupTimer;

    public OUIManager(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.ouis = ImmutableMap.builder().build();
        this.lookupTimer = nzyme.getMetrics().timer(MetricRegistry.name(MetricNames.OUI_LOOKUP_TIMING, new String[0]));
    }

    @Nullable
    public String lookupBSSID(String bssid) {
        if (this.ouis == null || this.ouis.isEmpty()) {
            LOG.debug("Internal OUI table is NULL or empty.");
            return null;
        }
        if (bssid == null || bssid.isEmpty()) {
            LOG.debug("Passed OUI is null or empty.");
            return null;
        }
        Timer.Context timer = this.lookupTimer.time();
        String result = this.ouis.get(bssid.toUpperCase().substring(0, 8).replace(":", ""));
        timer.stop();
        return result;
    }

    public void fetchAndUpdate() throws IOException {
        if (!this.nzyme.getConfiguration().fetchOuis()) {
            LOG.info("Fetching OUIs has been disabled in nzyme configuration. Not fetching.");
            return;
        }
        LOG.info("Fetching and updating list of OUIs from [{}]. This might take a moment.", (Object)OUI_SOURCE);
        OkHttpClient c2 = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.MINUTES).followRedirects(true).build();
        Stopwatch downloadTime = Stopwatch.createStarted();
        Response response = c2.newCall(new Request.Builder().addHeader("User-Agent", "nzyme").get().url(OUI_SOURCE).build()).execute();
        downloadTime.stop();
        if (!response.isSuccessful()) {
            throw new RuntimeException("Expected HTTP 200 but got HTTP " + response.code());
        }
        if (response.body() == null) {
            throw new RuntimeException("Empty response.");
        }
        Stopwatch parsingTime = Stopwatch.createStarted();
        HashMap<String, String> map = Maps.newHashMap();
        try {
            for (String line : Splitter.on("\n").trimResults().omitEmptyStrings().split(response.body().string())) {
                Matcher m3;
                if (!line.contains("(base 16)") || !(m3 = LINE_REGEX.matcher(line)).find()) continue;
                map.put(m3.group(1).trim(), m3.group(2).trim());
            }
            parsingTime.stop();
        }
        catch (Exception e2) {
            throw new RuntimeException("OUI parsing error.", e2);
        }
        finally {
            response.body().close();
        }
        this.ouis = ImmutableMap.copyOf(map);
        LOG.info("Done! Now <{}> OUIs in memory. Download time <{}ms>, parsing time <{}s>.", (Object)this.ouis.size(), (Object)downloadTime.elapsed(TimeUnit.MILLISECONDS), (Object)parsingTime.elapsed(TimeUnit.SECONDS));
    }
}

