/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.notifications.uplinks.syslog;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.notifications.Notification;
import horse.wtf.nzyme.notifications.Uplink;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class SyslogUDPUplink
implements Uplink {
    private static final Logger LOG = LogManager.getLogger(SyslogUDPUplink.class);
    protected final UdpSyslogMessageSender sender;
    private final String nzymeId;

    protected SyslogUDPUplink(InetSocketAddress address, MessageFormat messageFormat, String nzymeId) {
        String hostname;
        this.nzymeId = nzymeId;
        this.sender = new UdpSyslogMessageSender();
        this.sender.setMessageFormat(messageFormat);
        this.sender.setSyslogServerHostname(address.getHostName());
        this.sender.setSyslogServerPort(address.getPort());
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e2) {
            hostname = "nzyme";
            LOG.error("Could not determine local hostname for syslog uplink. Falling back to [{}].", (Object)hostname, (Object)e2);
        }
        this.sender.setDefaultMessageHostname(hostname);
        this.sender.setDefaultAppName("nzyme");
        this.sender.setDefaultFacility(Facility.USER);
    }

    @Override
    public void notify(Notification notification, @Nullable Dot11MetaInformation meta) {
        try {
            this.sender.sendMessage(this.buildMessage(notification, meta));
        }
        catch (Exception e2) {
            LOG.info("Could not send syslog message.", (Throwable)e2);
        }
    }

    @Override
    public void notifyOfAlert(Alert alert) {
        try {
            StringBuilder sb = new StringBuilder("ALERT: ");
            sb.append(alert.getMessage());
            for (Map.Entry<String, Object> field : alert.getFields().entrySet()) {
                sb.append(" ").append(field.getKey()).append("=\"").append(field.getValue().toString().replace("\"", "\\\"")).append("\"");
            }
            sb.append(" ").append("nzyme_sensor_id").append("=\"").append(this.nzymeId).append("\"");
            sb.append(" ").append("nzyme_message_type").append("=\"alert\"");
            sb.append(" ").append("alert_type").append("=\"").append(alert.getType().toString().toLowerCase()).append("\"");
            this.sender.sendMessage(sb.toString());
        }
        catch (Exception e2) {
            LOG.info("Could not send syslog message.", (Throwable)e2);
        }
    }

    public String buildMessage(Notification notification, @Nullable Dot11MetaInformation meta) {
        StringBuilder sb = new StringBuilder(notification.getMessage());
        if (meta != null) {
            sb.append(" ").append("(").append(meta.getFrequency()).append("MHz @").append(" ").append(meta.getAntennaSignal()).append("dBm)");
        }
        for (Map.Entry<String, Object> field : notification.getAdditionalFields().entrySet()) {
            sb.append(" ").append(field.getKey()).append("=\"").append(field.getValue().toString().replace("\"", "\\\"")).append("\"");
        }
        sb.append(" ").append("nzyme_sensor_id").append("=\"").append(this.nzymeId).append("\"");
        sb.append(" ").append("nzyme_message_type").append("=\"frame_record\"");
        if (meta != null) {
            sb.append(" ").append("antenna_signal").append("=\"").append(meta.getAntennaSignal()).append("\"");
            sb.append(" ").append("frequency").append("=\"").append(meta.getFrequency()).append("\"");
            sb.append(" ").append("signal_quality").append("=\"").append(meta.getSignalQuality()).append("\"");
            if (meta.getMacTimestamp() >= 0L) {
                sb.append(" ").append("mac_timestamp").append("=\"").append(meta.getMacTimestamp()).append("\"");
            }
        }
        return sb.toString();
    }
}

