/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.notifications.uplinks.graylog;

import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.notifications.Notification;
import horse.wtf.nzyme.notifications.Uplink;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;

public class GraylogUplink
implements Uplink {
    private static final String SOURCE = "nzyme";
    private final String nzymeId;
    private final GelfTransport gelfTransport;

    public GraylogUplink(InetSocketAddress address, String nzymeId) {
        this.nzymeId = nzymeId;
        this.gelfTransport = GelfTransports.create(new GelfConfiguration(address).transport(GelfTransports.TCP).queueSize(512).connectTimeout(5000).reconnectDelay(1000).tcpNoDelay(true).sendBufferSize(32768));
    }

    @Override
    public void notify(Notification notification, @Nullable Dot11MetaInformation meta) {
        StringBuilder sb = new StringBuilder(notification.getMessage());
        if (meta != null) {
            sb.append(" ").append("(").append(meta.getFrequency()).append("MHz @").append(" ").append(meta.getAntennaSignal()).append("dBm)");
        }
        GelfMessage gelf = new GelfMessage(sb.toString(), SOURCE);
        gelf.addAdditionalFields(notification.getAdditionalFields());
        gelf.addAdditionalField("nzyme_sensor_id", this.nzymeId);
        gelf.addAdditionalField("nzyme_message_type", "frame_record");
        if (meta != null) {
            gelf.addAdditionalField("antenna_signal", meta.getAntennaSignal());
            gelf.addAdditionalField("frequency", meta.getFrequency());
            gelf.addAdditionalField("signal_quality", meta.getSignalQuality());
            if (meta.getMacTimestamp() >= 0L) {
                gelf.addAdditionalField("mac_timestamp", meta.getMacTimestamp());
            }
        }
        this.gelfTransport.trySend(gelf);
    }

    @Override
    public void notifyOfAlert(Alert alert) {
        GelfMessage gelf = new GelfMessage("ALERT: " + alert.getMessage(), SOURCE);
        gelf.addAdditionalField("nzyme_sensor_id", this.nzymeId);
        gelf.addAdditionalField("nzyme_message_type", "alert");
        gelf.addAdditionalField("alert_type", alert.getType().toString().toLowerCase());
        for (Map.Entry<String, Object> x2 : alert.getFields().entrySet()) {
            gelf.addAdditionalField("alert_" + x2.getKey(), x2.getValue());
        }
        this.gelfTransport.trySend(gelf);
    }
}

