/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.events;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.events.Event;
import horse.wtf.nzyme.events.db.EventRecord;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;
import org.joda.time.DateTime;

public class EventService {
    private static final Logger LOG = LogManager.getLogger(EventService.class);
    private final NzymeLeader nzyme;
    private final Map<Event.TYPE, List<Consumer<Event>>> subscribers;

    public EventService(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.subscribers = Maps.newHashMap();
    }

    public void recordEvent(Event event) {
        this.recordEvent(event, DateTime.now());
    }

    public void recordEvent(Event event, DateTime timestamp) {
        try {
            if (this.subscribers.containsKey((Object)event.type())) {
                for (Consumer<Event> callback : this.subscribers.get((Object)event.type())) {
                    callback.accept(event);
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Callback for event [{}] failed. Continuing.", (Object)event, (Object)e2);
        }
        this.nzyme.getDatabase().useHandle(handle -> handle.execute("INSERT INTO events(type, name, description, created_at) VALUES(?, ?, ?, ?)", event.type().toString(), event.name(), event.description(), timestamp.withMillisOfSecond(0)));
    }

    public long countAll() {
        return this.nzyme.getDatabase().withHandle(handle -> handle.createQuery("SELECT COUNT(*) FROM events").mapTo(Long.class).one());
    }

    public long countAllOfTypeOfLast24Hours(Event.TYPE type) {
        return this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery("SELECT COUNT(*) FROM events WHERE type = :type AND created_at > :created_at").bind("type", type.toString())).bind("created_at", (Object)DateTime.now().minusHours(24))).mapTo(Long.class).one());
    }

    public List<EventRecord> findAllEventsOfLast24Hours() {
        return this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT * FROM events WHERE created_at > :created_at ORDER BY created_at").bind("created_at", (Object)DateTime.now().minusHours(24))).mapTo(EventRecord.class).list());
    }

    public void subscribe(Event.TYPE type, Consumer<Event> callback) {
        this.subscribers.putIfAbsent(type, Lists.newArrayList());
        this.subscribers.get((Object)type).add(callback);
    }

    public Map<Event.TYPE, List<Consumer<Event>>> getSubscribers() {
        return Maps.newHashMap(this.subscribers);
    }
}

