/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.probes;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.events.BrokenProbeEvent;
import horse.wtf.nzyme.periodicals.Periodical;
import java.util.ArrayList;

public class ProbeStatusMonitor
extends Periodical {
    private final NzymeLeader nzyme;

    public ProbeStatusMonitor(NzymeLeader nzyme) {
        this.nzyme = nzyme;
    }

    @Override
    protected void execute() {
        for (Dot11Probe probe : this.nzyme.getProbes()) {
            if (probe.isActive() && probe.isInLoop()) continue;
            ArrayList<String> errors = Lists.newArrayList();
            if (!probe.isActive()) {
                errors.add("not sending or receiving frames");
            }
            if (!probe.isInLoop()) {
                errors.add("not in send/receive loop");
            }
            this.nzyme.getEventService().recordEvent(new BrokenProbeEvent(probe.getName(), Joiner.on(", ").join(errors)));
        }
    }

    @Override
    public String getName() {
        return "ProbeStatusMonitor";
    }
}

