/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.probes;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import horse.wtf.nzyme.channels.ChannelHopper;
import horse.wtf.nzyme.dot11.deception.traps.Trap;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeConfiguration;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeInitializationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;

public class Dot11SenderProbe
extends Dot11Probe {
    private static final Logger LOG = LogManager.getLogger(Dot11SenderProbe.class);
    private final AtomicBoolean inLoop = new AtomicBoolean(false);
    private PcapHandle pcap;
    private final Dot11ProbeConfiguration configuration;
    private final ChannelHopper channelHopper;
    private final Trap trap;
    private long totalFrames;
    private DateTime mostRecentFrameTimestamp;

    public Dot11SenderProbe(Dot11ProbeConfiguration configuration, Trap trap, MetricRegistry metrics) {
        super(configuration, metrics);
        this.trap = trap;
        this.configuration = configuration;
        this.totalFrames = 0L;
        this.channelHopper = new ChannelHopper(this, configuration);
        this.channelHopper.initialize();
    }

    @Override
    public void initialize() throws Dot11ProbeInitializationException {
        PcapNetworkInterface networkInterface;
        try {
            networkInterface = Pcaps.getDevByName(this.configuration.networkInterfaceName());
        }
        catch (PcapNativeException e2) {
            throw new Dot11ProbeInitializationException("Could not get network interface [" + this.configuration.networkInterfaceName() + "].", e2);
        }
        if (networkInterface == null) {
            throw new Dot11ProbeInitializationException("Could not get network interface [" + this.configuration.networkInterfaceName() + "]. Does it exist and could it be that you have to be root? Is it up?");
        }
        PcapHandle.Builder phb = new PcapHandle.Builder(networkInterface.getName()).rfmon(!this.configuration.skipEnableMonitor()).snaplen(65536).promiscuousMode(PcapNetworkInterface.PromiscuousMode.PROMISCUOUS).timeoutMillis(100).bufferSize(0x500000).timestampPrecision(PcapHandle.TimestampPrecision.MICRO);
        try {
            this.pcap = phb.build();
            this.pcap.setFilter("type mgt and (subtype deauth or subtype probe-req or subtype probe-resp or subtype beacon or subtype assoc-req or subtype assoc-resp or subtype disassoc or subtype auth)", BpfProgram.BpfCompileMode.OPTIMIZE);
        }
        catch (Exception e3) {
            throw new Dot11ProbeInitializationException("Could not build PCAP handle.", e3);
        }
        LOG.info("PCAP handle for [{}] acquired. Cycling through channels <{}>.", (Object)this.configuration.probeName(), (Object)Joiner.on(",").join(this.configuration.channels()));
    }

    @Override
    public Runnable loop() {
        return () -> {
            while (true) {
                block16: {
                    try {
                        if (this.isInLoop()) break block16;
                        this.initialize();
                    }
                    catch (Dot11ProbeInitializationException e2) {
                        this.inLoop.set(false);
                        LOG.error("Could not initialize probe [{}]. Retrying soon.", (Object)this.getName(), (Object)e2);
                        try {
                            Thread.sleep(2500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                try {
                    this.inLoop.set(true);
                    boolean status = this.trap.run();
                    this.totalFrames += (long)this.trap.framesPerExecution();
                    if (!status) continue;
                    this.mostRecentFrameTimestamp = DateTime.now();
                    continue;
                }
                catch (Exception e3) {
                    this.inLoop.set(false);
                    LOG.error("Could not set trap [{}].", (Object)this.trap.getClass().getCanonicalName(), (Object)e3);
                    continue;
                }
                finally {
                    try {
                        Thread.sleep(this.trap.getDelayMilliseconds());
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        };
    }

    @Override
    public boolean isInLoop() {
        return this.inLoop.get();
    }

    @Override
    public Integer getCurrentChannel() {
        return this.channelHopper.getCurrentChannel();
    }

    @Override
    public Long getTotalFrames() {
        return this.totalFrames;
    }

    public Trap getTrap() {
        return this.trap;
    }

    @Override
    @Nullable
    public DateTime getMostRecentFrameTimestamp() {
        return this.mostRecentFrameTimestamp;
    }
}

