/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.probes;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeConfiguration;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeInitializationException;
import org.joda.time.DateTime;

public abstract class Dot11Probe {
    private final Dot11ProbeConfiguration configuration;
    protected final MetricRegistry metrics;

    public abstract void initialize() throws Dot11ProbeInitializationException;

    public abstract Runnable loop() throws Dot11ProbeInitializationException;

    public abstract boolean isInLoop();

    public abstract Integer getCurrentChannel();

    public abstract Long getTotalFrames();

    public Dot11Probe(Dot11ProbeConfiguration configuration, MetricRegistry metrics) {
        this.configuration = configuration;
        this.metrics = metrics;
    }

    public boolean isActive() {
        DateTime ts = this.getMostRecentFrameTimestamp();
        if (ts == null) {
            return false;
        }
        return ts.isAfter(DateTime.now().minusSeconds(this.configuration.maxIdleTimeSeconds()));
    }

    public Dot11ProbeConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.configuration.probeName();
    }

    public abstract DateTime getMostRecentFrameTimestamp();
}

