/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.Dot11TaggedParameters;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import org.pcap4j.packet.IllegalRawDataException;

public class Dot11ProbeResponseFrameParser
extends Dot11FrameParser<Dot11ProbeResponseFrame> {
    private final Anonymizer anonymizer;

    public Dot11ProbeResponseFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11ProbeResponseFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        String ssid;
        Dot11ManagementFrame probeReponse = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        Dot11TaggedParameters taggedParameters = new Dot11TaggedParameters(this.metrics, 36, payload);
        try {
            ssid = taggedParameters.getSSID();
        }
        catch (Dot11TaggedParameters.NoSuchTaggedElementException e2) {
            throw new IllegalRawDataException("No SSID in probe-resp frame. Not even empty SSID. This is a malformed frame.");
        }
        String destination = "";
        if (probeReponse.getHeader().getAddress1() != null) {
            destination = probeReponse.getHeader().getAddress1().toString();
        }
        String transmitter = "";
        if (probeReponse.getHeader().getAddress2() != null) {
            transmitter = probeReponse.getHeader().getAddress2().toString();
        }
        if (this.anonymizer.isEnabled()) {
            ssid = this.anonymizer.anonymizeSSID(ssid);
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
            destination = this.anonymizer.anonymizeBSSID(destination);
        }
        return Dot11ProbeResponseFrame.create(ssid, destination, transmitter, taggedParameters.fingerprint(), taggedParameters, meta, payload, header);
    }
}

