/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import org.pcap4j.packet.IllegalRawDataException;

public abstract class Dot11FrameParser<T> {
    protected final MetricRegistry metrics;
    private final Timer timer;

    protected Dot11FrameParser(MetricRegistry metrics) {
        this.metrics = metrics;
        this.timer = metrics.timer(MetricRegistry.name(this.getClass(), "parseTime"));
    }

    protected abstract T doParse(byte[] var1, byte[] var2, Dot11MetaInformation var3) throws IllegalRawDataException, MalformedFrameException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T parse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        T result;
        Timer.Context time = this.timer.time();
        try {
            result = this.doParse(payload, header, meta);
        }
        finally {
            time.stop();
        }
        return result;
    }
}

