/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11LeavingReason;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import org.pcap4j.packet.IllegalRawDataException;

public class Dot11DeauthenticationFrameParser
extends Dot11FrameParser<Dot11DeauthenticationFrame> {
    private final Anonymizer anonymizer;

    public Dot11DeauthenticationFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11DeauthenticationFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException {
        Dot11ManagementFrame deauth = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        String destination = "";
        if (deauth.getHeader().getAddress1() != null) {
            destination = deauth.getHeader().getAddress1().toString();
        }
        String transmitter = "";
        if (deauth.getHeader().getAddress2() != null) {
            transmitter = deauth.getHeader().getAddress2().toString();
        }
        String bssid = "";
        if (deauth.getHeader().getAddress3() != null) {
            bssid = deauth.getHeader().getAddress3().toString();
        }
        short reasonCode = Dot11LeavingReason.extract(payload, header);
        String reasonString = Dot11LeavingReason.lookup(reasonCode);
        if (this.anonymizer.isEnabled()) {
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
            destination = this.anonymizer.anonymizeBSSID(destination);
        }
        return Dot11DeauthenticationFrame.create(destination, transmitter, bssid, reasonCode, reasonString, meta, payload, header);
    }
}

