/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.Dot11TaggedParameters;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import org.pcap4j.packet.IllegalRawDataException;

public class Dot11BeaconFrameParser
extends Dot11FrameParser<Dot11BeaconFrame> {
    private final Anonymizer anonymizer;

    public Dot11BeaconFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11BeaconFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        String ssid;
        Dot11ManagementFrame beacon = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        Dot11TaggedParameters taggedParameters = new Dot11TaggedParameters(this.metrics, 36, payload);
        String transmitter = "";
        if (beacon.getHeader().getAddress2() != null) {
            transmitter = beacon.getHeader().getAddress2().toString();
        }
        try {
            ssid = taggedParameters.getSSID();
        }
        catch (Dot11TaggedParameters.NoSuchTaggedElementException e2) {
            ssid = null;
        }
        if (this.anonymizer != null && this.anonymizer.isEnabled()) {
            ssid = this.anonymizer.anonymizeSSID(ssid);
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
        }
        return Dot11BeaconFrame.create(ssid, transmitter, taggedParameters.fingerprint(), taggedParameters, meta, payload, header);
    }
}

