/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11AuthenticationFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public class Dot11AuthenticationFrameParser
extends Dot11FrameParser<Dot11AuthenticationFrame> {
    private final Anonymizer anonymizer;
    private static final int MAC_HEADER_LEN = 24;
    private static final int ALGO_NUM_LENGTH = 2;
    private static final int ALGO_NUM_POSITION = 24;
    private static final int TRANSACTION_SEQ_NO_LENGTH = 2;
    private static final int TRANSACTION_SEQ_NO_POSITION = 26;
    private static final int STATUS_CODE_LENGTH = 2;
    private static final int STATUS_CODE_POSITION = 28;

    public Dot11AuthenticationFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11AuthenticationFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        Object status;
        ALGORITHM_TYPE algorithm;
        Dot11ManagementFrame auth = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        try {
            ByteArrays.validateBounds(payload, 24, 2);
            ByteArrays.validateBounds(payload, 26, 2);
            ByteArrays.validateBounds(payload, 28, 2);
        }
        catch (Exception e2) {
            throw new MalformedFrameException("Payload out of bounds. (1) Ignoring.");
        }
        byte[] algoNumArray = ByteArrays.getSubArray(payload, 24, 2);
        byte[] transactionSeqArray = ByteArrays.getSubArray(payload, 26, 2);
        byte[] statusCodeArray = ByteArrays.getSubArray(payload, 28, 2);
        short algorithmCode = ByteArrays.getShort(algoNumArray, 0, ByteOrder.LITTLE_ENDIAN);
        switch (algorithmCode) {
            case 0: {
                algorithm = ALGORITHM_TYPE.OPEN_SYSTEM;
                break;
            }
            case 1: {
                algorithm = ALGORITHM_TYPE.SHARED_KEY;
                break;
            }
            case 3: {
                algorithm = ALGORITHM_TYPE.SAE;
                break;
            }
            default: {
                throw new MalformedFrameException("Invalid algorithm type with code [" + algorithmCode + "]. Skipping.");
            }
        }
        short statusCode = ByteArrays.getShort(statusCodeArray, 0, ByteOrder.LITTLE_ENDIAN);
        switch (statusCode) {
            case 0: {
                status = "success";
                break;
            }
            case 1: {
                status = "failure";
                break;
            }
            default: {
                status = "Invalid/Unknown (" + statusCode + ")";
            }
        }
        short transactionSequence = ByteArrays.getShort(transactionSeqArray, 0, ByteOrder.LITTLE_ENDIAN);
        String destination = "";
        if (auth.getHeader().getAddress1() != null) {
            destination = auth.getHeader().getAddress1().toString();
        }
        String transmitter = "";
        if (auth.getHeader().getAddress2() != null) {
            transmitter = auth.getHeader().getAddress2().toString();
        }
        if (this.anonymizer.isEnabled()) {
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
            destination = this.anonymizer.anonymizeBSSID(destination);
        }
        return Dot11AuthenticationFrame.create(algorithm, statusCode, (String)status, transactionSequence, destination, transmitter, meta, payload, header);
    }

    public static enum ALGORITHM_TYPE {
        OPEN_SYSTEM,
        SHARED_KEY,
        SAE;

    }
}

