/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11AssociationResponseFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public class Dot11AssociationResponseFrameParser
extends Dot11FrameParser<Dot11AssociationResponseFrame> {
    private final Anonymizer anonymizer;
    private static final int STATUS_CODE_POSITION = 26;
    private static final int STATUS_CODE_LENGTH = 2;

    public Dot11AssociationResponseFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11AssociationResponseFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        Dot11ManagementFrame associationResponse = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        try {
            ByteArrays.validateBounds(payload, 0, 27);
        }
        catch (Exception e2) {
            throw new MalformedFrameException("Payload out of bounds. (1) Ignoring.");
        }
        short responseCode = ByteArrays.getShort(new byte[]{payload[26], payload[27]}, 0, ByteOrder.LITTLE_ENDIAN);
        if (responseCode < 0) {
            throw new MalformedFrameException("Invalid response code <" + responseCode + ">");
        }
        String response = "refused";
        if (responseCode == 0) {
            response = "success";
        }
        String destination = "";
        if (associationResponse.getHeader().getAddress1() != null) {
            destination = associationResponse.getHeader().getAddress1().toString();
        }
        String transmitter = "";
        if (associationResponse.getHeader().getAddress2() != null) {
            transmitter = associationResponse.getHeader().getAddress2().toString();
        }
        if (this.anonymizer.isEnabled()) {
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
            destination = this.anonymizer.anonymizeBSSID(destination);
        }
        return Dot11AssociationResponseFrame.create(transmitter, destination, response, responseCode, meta, payload, header);
    }
}

