/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks.signalstrength.tracks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.hash.Hashing;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.AutoValue_Track;
import org.joda.time.DateTime;

@AutoValue
public abstract class Track {
    @JsonProperty
    public abstract DateTime start();

    @JsonProperty
    public abstract DateTime end();

    @JsonProperty(value="centerline")
    public abstract int centerline();

    @JsonProperty(value="min_signal")
    public abstract int minSignal();

    @JsonProperty(value="max_signal")
    public abstract int maxSignal();

    @JsonProperty(value="id")
    public String id() {
        return Hashing.sha256().hashBytes((this.start().toString() + this.centerline()).getBytes()).toString().substring(0, 6);
    }

    public static Track create(DateTime start, DateTime end, int centerline, int minSignal, int maxSignal) {
        return Track.builder().start(start).end(end).centerline(centerline).minSignal(minSignal).maxSignal(maxSignal).build();
    }

    public static Builder builder() {
        return new AutoValue_Track.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder start(DateTime var1);

        public abstract Builder end(DateTime var1);

        public abstract Builder centerline(int var1);

        public abstract Builder minSignal(int var1);

        public abstract Builder maxSignal(int var1);

        public abstract Track build();
    }
}

